#include "mbed.h"
#include "rtos.h"
#include "pin.h"
#include "angle.h"
#include "can.h"

Serial pc(USBTX, USBRX);
IRsensor sharp(p17);
CANbus can(p30,p29);

DigitalOut led(LED1);
//CANbus can(p30,p29);

Mutex mutex1;

float curr_req = 0;
float K[3] = {17.0, 3.6, -0.14};
float Mz = 0;
float Mm = 0;
extern float vel_temp = 286331.153;
float phi;      //uhel micku na kole
float omega;    //uhlova rychlost micku
float phi_old;  //starsi hodnota uhlu micku

int jj = 0;


//vlakno pro snimani uhlu micku
void sensor_thread(void const *args) {
    while(true) {
        mutex1.lock();
        phi = sharp.get_angle();
        omega = (phi - phi_old)/0.040;
        phi_old = phi;
        //pc.printf("%2.3f\n",phi);
        mutex1.unlock();
        Thread::wait(40);
    }
}

//vlakno pro vysilani synchronizace
void sync_thread(void const *args) {
    while(true) {
        can.servo_sync();
        Thread::wait(5);
    }
}


    
int main() {
    pc.baud(19200);
    pc.format(8,SerialBase::None,1);

    Thread thread_sens(sensor_thread);
    Thread thread_sync(sync_thread);
    i = 20;
    //can.can_init();
    can.enable_servo();
    can.set_mode();
    can.set_current(0);
    
    while(phi < 0.3 && (rSpeed < 25 || rSpeed > -25) && (curr_req < 15.0 || curr_req > -15.0)){
        can.actual_speed();
        Mz = (phi*K[0] +omega*K[1] + rSpeed*K[2]);
        Mm = Mz/7.7;
        curr_req = Mm/0.3;
        printf("rSpeed = %2.2f phi = %2.2f comega= %2.2f Mz=%2.2f Mm = %2.2f curr = %2.2f req_curr = %2.2f\n",rSpeed, phi,omega, Mz, Mm,current,curr_req);
        can.set_current(curr_req);
        //printf("phi = %2.2f\n",phi);
        wait(0.04);
    }
    can.disable_servo();
}
