#ifndef CANPROTOCOL_H
#define CANPROTOCOL_H

#define ID_SERVO            0x01
#define SDO_REQUEST_ID      0x600+ID_SERVO
#define SDO_RESPONSE_ID     0x580+ID_SERVO
#define PDO_TRANSMIT_ID     0x180+ID_SERVO
#define PDO_RECEIVE_ID      0x200+ID_SERVO
#define SYNC_ID             0x80
  
#define SERVO_MODE          0x1EF
#define MASTER_CMD          0x1ED


#define CMD_SDO_READ_REQ        0x40
#define CMD_SDO_READ_RES_2      0x4B
#define CMD_SDO_READ_RES_4      0x43

#define CMD_SDO_WRITE_REQ_24    0x22
#define CMD_SDO_WRITE_REQ_2     0x2B         
#define CMD_SDO_WRITE_REQ_4     0x23
#define CMD_SDO_WRITE_RES       0x60
#define CMD_SDO_WRITE_ERR       0x80


#define REQ_DISABLE_SERVO       0x01
#define REQ_ENABLE_SERVO        0x02

#define SPEED_MODE              0x200002
#define MOMENT_MODE             0x200001

extern float current;
extern int vel;
extern int mode;
extern float rSpeed;
extern float mSpeed;
extern char data[4],address[2],data_size,cmd;

class CANbus {
    CAN Can;
    int get_data(char data[], char size);
    int send_SDO_request(char cmd, int adr, char size,int data);
    int send_PDO_speed(int velocity);
    int send_PDO_current(float curr);
    
public:
    CANbus(PinName CANpin1,PinName CANpin2);
    void CAN_frame_received(void);
    void servo_sync(void);
    void enable_servo(void);
    void disable_servo(void);
    void set_mode(void);
    void get_mode(void);
    void set_current(float cur);
    void actual_speed(void); 
    void actual_current(void);
};


#endif