#ifndef _COMMON_H
#define _COMMON_H


#include "mbed.h"
#include "rtos.h"
#include "can.h"
#include "ultrasonic.h"
#include "ledsensor.h"
#include "control.h"
#include "print.h"

/* PROGRAM MODES */
#define WAITING  0x01
#define STARTING 0x02
#define RUNNING  0x03
#define STOP     0x04


#define ULTRA   0
#define LASER   1


#define PID   0
#define ST_FEEDBACK   1

typedef struct states_t {
    float phi1;
    float omega1;
    float phi2;
    float omega2;
    float current;  
} states_t;



extern InterruptIn butOff;

extern cUltrasonic us100;
extern cCan can;
extern cPrint pc;
extern cLedSensor baumer;
extern cControl control;

extern float K[4];
extern char first;
extern states_t states;
extern Mutex mutex1;
extern char  programMode;
extern char stisknut;
extern char sensor;
extern char controller;


void stopProg();


/* 
 * Thread for inicialization
 */
void initThread(void const *args);

/*
 * Thread for led diodes
 */
void ledThread(void const *args);

/*
 * Thread for ultrasonic sensor
 */
void usThread(void const *args);

/*
 * Thread for baumer sensor
 */
void laserThread(void const *args);

/*
 * Thread for control
 */
void controlThread(void const *args);

/*
 * Thread for collect data
 */
void collectThread(void const *args);

/*
 * Thread for sending synchronization
 */
void syncThread(void const *args);

/*
 * Thread for print results
 */
void printThread(void const *args);

#endif