#include "mbed.h"
#include "rtos.h"
#include "threads.h"
#include "ultrasonic.h"
#include "ledsensor.h"
#include "can.h"
#include "control.h"
#include "print.h"


int main() {
    Thread threadInit(initThread,NULL,osPriorityHigh);
    
    Thread threadUs(usThread,NULL,osPriorityHigh);
    Thread threadLaser(laserThread,NULL,osPriorityHigh);
    
    if(sensor == ULTRA) {
        threadLaser.terminate();
    }
    if(sensor == LASER)
        threadUs.terminate();
    
       
    Thread threadSync(syncThread,NULL,osPriorityNormal);
    pc.log("Vytvoreno vlakno synchronizace");
    
    Thread threadControl(controlThread,NULL,osPriorityHigh);
    pc.log("Vytvoreno vlakno pro rizeni");
    
    Thread threadCollect(collectThread,NULL,osPriorityHigh);
    pc.log("Vytvoreno vlakno pro sber dat");
    
    Thread threadPrint(printThread,NULL,osPriorityLow);
    pc.log("Vytvoreno vlakno pro vypis");
    
    Thread threadLed(ledThread,NULL,osPriorityHigh);        
    pc.log("Vytvoreno vlakno pro zobrazeni stavu programu");
    
    butOff.rise(&stopProg);
    us100.thread = &threadCollect;
    baumer.thread = &threadCollect;
    can.thread = &threadCollect;
    
    Thread::wait(osWaitForever);
}