#ifndef _ANGLE_H
#define _ANGLE_H

#include "mbed.h"
#include "rtos.h"
#include "FastAnalogIn.h"

class cLedSensor {
    public:     
        /* Constructor */
        cLedSensor(PinName pinAnalog);
        
        /* Desctructor*/
        ~cLedSensor();
        
        /* Get analog value of voltage */
        float getVoltage();
        
        /* This method reads analog value */
        void read();
        
        /* Pointer to collect thread */
        Thread* thread;
    
    private:
        /*Fast analogIn pin*/
        FastAnalogIn analog;
        
        float voltage;
        float volt_s[5];
        float volt_temp;
        int i;  
};
#endif