#include "ledsensor.h"
#include "threads.h"


/*-- konstruktor --*/
cLedSensor::cLedSensor(PinName pinAnalog) : analog(pinAnalog) {
    voltage = 0;
    volt_temp = 0;
    i = 0;
}

cLedSensor::~cLedSensor() 
{

}

void cLedSensor::read(void) {
    volt_temp = analog.read();
    volt_s[i] = volt_temp;
    i++;
    if(i >= 5) {
        voltage = (volt_s[0] + volt_s[1] + volt_s[2] + volt_s[3] + volt_s[4]) / 5.0;
        i = 0;
        thread->signal_set(0x01);
    }
}

float cLedSensor::getVoltage(void) {
    return voltage;  
}