#ifndef _ULTRASONIC_H
#define _ULTRASONIC_H

#include "mbed.h"
#include "rtos.h"

class cUltrasonic {
    public:     
        cUltrasonic(PinName pinEcho, PinName pinTrig);
        
        /* This method set trigger */
        void setTrig();
        
        /* This method returns width of received pulse*/
        int getPulseWidth();
        
        /* Pointer to thread*/
        Thread* thread;
    
    private:
        DigitalOut trig;
        InterruptIn echo;
        
        Timer timer;
        float pulseWidth;
        
        /* ISR of rising edge */
        void riseEdge(void);
        
        /* ISR of falling edge*/
        void fallEdge(void);
    

};
#endif