#include "ultrasonic.h"
#include "threads.h"


/*
* Constructor 
*/
cUltrasonic::cUltrasonic(PinName pinEcho, PinName pinTrig) : echo(pinEcho), trig(pinTrig) {
    echo.rise(this,&cUltrasonic::riseEdge);
    echo.fall(this,&cUltrasonic::fallEdge);
}


/* 
* This method set trigger
*/
void cUltrasonic::setTrig(void) {
        trig.write(0);
        wait_us(5);
        trig.write(1); 
        wait_us(10);
        trig.write(0);
}

/* 
* ISR of rising edge of received pulse 
* in this thread the timer starts
*/
void cUltrasonic::riseEdge(void) {
    timer.start();  
}

/*
* ISR of falling edge of received pulse
* in this thread is saved width of pulse and signal set to collect thread
*/
void cUltrasonic::fallEdge(void) {
    timer.stop();
    pulseWidth = timer.read_us();
    timer.reset();
    thread->signal_set(0x01);
}

/*
* This method returns width  of pulse
*/
int cUltrasonic::getPulseWidth(void) {
    return pulseWidth;  
}