#include "mbed.h"
#include "rtos.h"
#include "threads.h"
#include "ultrasonic.h"
#include "ledsensor.h"
#include "can.h"
#include "control.h"
#include "print.h"


int main() {
    Thread threadInit(initThread,NULL,osPriorityHigh);
    
    Thread threadUs(usThread,NULL,osPriorityHigh);
    Thread threadLaser(laserThread,NULL,osPriorityHigh);
    if(sensor == ULTRA) {
        threadLaser.terminate();
    }
    if(sensor == LASER)
        threadUs.terminate();
    Thread threadSync(syncThread,NULL,osPriorityAboveNormal);    
    Thread threadControl(controlThread,NULL,osPriorityHigh);    
    Thread threadCollect(collectThread,NULL,osPriorityRealtime); 
    Thread threadPrint(printThread,NULL,osPriorityLow);    
    Thread threadLed(ledThread,NULL,osPriorityAboveNormal);    
    
    butOff.rise(&stopProg);
    us100.thread = &threadCollect;
    baumer.thread = &threadCollect;
    can.thread = &threadCollect;
    
    Thread::wait(osWaitForever);
}