#include "print.h"
#include "threads.h"


cPrint::cPrint(PinName pinT, PinName pinR): s(pinT,pinR) {
    s.baud(9600);
    timer.start();
    t = 0;
    LocalFileSystem local("local");
    cPrint::open();
};

void cPrint::log (char *message) {
    s.printf("* * * %s * * *\n",message);
}

void cPrint::print(float data) {
    s.printf("%3.3f\n",data);
    
}

void cPrint::print(char data) {
    s.printf("%d\n",data);
    
}

void cPrint::printStates() {
    t = timer.read();
    fprintf(fp, "%2.4f %2.4f %2.4f %2.4f %2.4f %2.4f \r\n",states.phi1,states.omega1,states.phi2,states.omega2,states.current,t);
}

int cPrint::close() {
    timer.stop();
    return fclose(fp);
}

void cPrint::open() {
    fp = fopen("/local/charky.csv", "w");
}