/*
* File:         can.h
* Description:  jojo
* Version:      1.1
* Created:      1. 2. 2015
* Author:       Roman Krejci
*/
#ifndef CANPROTOCOL_H
#define CANPROTOCOL_H

#define ID_SERVO            0x01
#define SDO_REQUEST_ID      0x600+ID_SERVO
#define SDO_RESPONSE_ID     0x580+ID_SERVO
#define PDO_TRANSMIT_ID     0x180+ID_SERVO
#define PDO_RECEIVE_ID      0x200+ID_SERVO
#define SYNC_ID             0x80
  
#define SERVO_MODE          0x1EF
#define MASTER_CMD          0x1ED


#define CMD_SDO_READ_REQ        0x40
#define CMD_SDO_READ_RES_2      0x4B
#define CMD_SDO_READ_RES_4      0x43

#define CMD_SDO_WRITE_REQ_24    0x22
#define CMD_SDO_WRITE_REQ_2     0x2B         
#define CMD_SDO_WRITE_REQ_4     0x23
#define CMD_SDO_WRITE_RES       0x60
#define CMD_SDO_WRITE_ERR       0x80


#define REQ_DISABLE_SERVO       0x01
#define REQ_ENABLE_SERVO        0x02
#define REQ_NULL_RES            0x07


#define SPEED_MODE              0x200002
#define MOMENT_MODE             0x200001

#define CAN_FREQ                500000

#include "mbed.h"
#include "rtos.h"

class cCan 
{
    public: 
        cCan(PinName CANpin1,PinName CANpin2);
        void CAN_frame_received(void);
        void sync(void);
        
        /* For enable servo */
        void enableServo(void);
        
        /* For disable servo */
        void disableServo(void);
        
        /* For null resolver */
        void nullResolver(void);
        
        /* For set mode of servo */
        void setMode(int req_mode);
        
        /* This method send SDO request of mode of servo */
        void get_mode(void);
        
        /* Get angular position of wheel */
        float getPhi(void);
        
        /* Get angular velocity of wheel */
        float getOmega(void);
        
        
        /* For setting required current */
        void setCurrent(float cur);
        
        /* This method sends SDO request of actuall speed */
        void actual_speed(void); 
        
        int mode;
        
        /* Pointer to collect thread */
        Thread* thread;
    
    private:
        /* CAN interface */
        CAN Can;
        
        /* */
        char data[4], address[2], data_size, cmd; 
        
        /* angular position of wheel */
        float phi;
        
        /* angular velocity of wheel */
        float omega;
        
        /* current of motor*/
        float current;

        /* This method convert bytes to data */
        int get_data(char data[], char size);
        
        /* This method seds SDO request to servoamplifier */
        int send_SDO_request(char cmd, int adr, char size,int data);
        
        /* This method sends PDO with required current */
        int send_PDO_current(float curr);
    

};


#endif