#include "mbed.h"

#define MQTT_MAX_PACKET_SIZE 400   
#define MQTT_MAX_PAYLOAD_SIZE 300 
 
void ibm_cloud_demo(NetworkInterface *net)
{
    TCPSocket socket;
    MQTTClient client(&socket);
 
    SocketAddress a;
    char* hostname = "quickstart.messaging.internetofthings.ibmcloud.com";
    net->gethostbyname(hostname, &a);
    int port = 1883;
    a.set_port(port);
 
    printf("Connecting to %s:%d\r\n", hostname, port);
 
    socket.open(net);
    printf("Opened socket\n\r");
    int rc = socket.connect(a);
    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);
    printf("Connected socket\n\r");
 
 
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "d:quickstart:my_test:my_test_board";
    data.username.cstring = "testuser";
    data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
 
    MQTT::Message message;
 
    char buf[MQTT_MAX_PAYLOAD_SIZE];
    float temp = 1;
    float press = 2; 
    float hum = 3;
 
    sprintf(buf,
     "{\"d\":{\"ST\":\"Nucleo-IoT-mbed\",\"Temp\":%0.4f,\"Pressure\":%0.4f,\"Humidity\":%0.4f}}",
              temp, press, hum);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf);
 
    char* topic = "iot-2/evt/my_event/fmt/json";
 
    if( (message.payloadlen + strlen(topic)+1) >= MQTT_MAX_PACKET_SIZE )
        printf("message too long!\r\n");
    
    rc = client.publish(topic, message);
    return;       
}


nt main()
{
   ibm_cloud_demo(NetworkInterface *net);
}
