#include "mbed.h"
#include "CCS811.h"
#include "DHT.h"

eType partname = DHT11;
eScale tmp_fmt = CELCIUS;
Serial m_pc(USBTX, USBRX);

int main() {
    m_pc.baud(9600);
    
    DHT dht(p26, partname);
    
    I2C i2c_ccs811(p28, p27);
    // i2c_ccs811.frequency(100000);
    CCS811 ccs(i2c_ccs811, m_pc);

    {
        char res = ccs.init();
        if (res != 0) printerr(m_pc, res);
    }
    
    {
        char status = ccs.readStatus();
        if (status & 0x01){
            char errid = ccs.readErr();
            printerr_reg1(m_pc, errid);
        }
    }
    m_pc.printf("Init Done\r\n");
    
    uint16_t co2, tvoc;
    while(1) {
        wait(3);
        int dhtres;
        if ((dhtres = dht.readData()) != 0){
            m_pc.printf("ERROR when reading DHT11: %d\r\n", dhtres);
            continue;
        }
        float celsius = dht.ReadTemperature(tmp_fmt);
        float humidity = dht.ReadHumidity();
        m_pc.printf("DEBUG: celsius = %f, humidity = %f\r\n", celsius, humidity);
        ccs.setEnvironment(celsius, humidity);
        while(!ccs.readStatus() & 0x08); // wait for DATA_READY
        int err;
        if((err = ccs.readData(&co2, &tvoc)) != 0){
            printerr(m_pc, err);
            continue;
        }
        m_pc.printf("%d %d\r\n", co2, tvoc);
    }
}
