#include "mbed.h"
#include "fastxml.h"

DigitalOut myled(LED1);

class tmpr : public FastXmlInterface {
  public:
    virtual bool processElement(const char *name, int argc, const char **argv, const char *data, int lineno) {
      printf("::%s\n", name);
      if(strncmp(name, "tmpr", 4)==0) {
        printf("tmpr: %s\n", data);
      }
      return true;
    }
};

const char *code = {
  "<root>\r\n"
  "  <chan1>\r\n"
  "    <tmpr>23.7</tmpr>\r\n"
  "  </chan1>\r\n"
  "  <chan2>\r\n"
  "    <tmpr>23.7</tmpr>\r\n"
  "  </chan2>\r\n"
  "</root>\r\n"
};

int main() {
    FastXml *xml = createFastXml();
    FastXmlInterface *tmp = new tmpr();
    xml->processXml(code, strlen(code), tmp);
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
