/* Function: hexview
 *  Prints an array of char to stdout in hex.
 *  The data is grouped in two 8 byte groups per line.
 *  Each byte is displayed as 2 hex digits and every 
 *  line starts with the address of the first byte.
 *
 *  There is no text view of a line.
 *
 * Variables:
 *  buffer - The array to display.
 *  size - The length of buffer.
 */
inline void hexview(char *buffer, unsigned int size) {
    for(int i = 0; i < size; ++i) {
        if((i%16)!=0) {
            printf(" ");
        } else {
            printf("%04X:  ", (i));
        }
        printf("%02hhx", buffer[i]);
        if((i%16) ==  7) { 
            printf(" ");
        }
        if((i%16) == 15) {
            printf("\n");
        }
    }
    printf("\n\n\n");
}