#include "mbed.h"
#include "Ethernet.h"
#include "hexview.h"

using namespace mbed;

DigitalOut led4(LED4);

Ethernet eth;

/*
__packed struct eth {
    unsigned char    dst[6];
    unsigned char    src[6];
    unsigned short   type;
};

void show(char *buffer, int size) {
    eth *e = (eth *)buffer;
    printf("Destination:  %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n",
            e->dst[0], e->dst[1], e->dst[2], e->dst[3], e->dst[4], e->dst[5]);
    printf("Source: %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n",
            e->src[0], e->src[1], e->src[2], e->src[3], e->src[4], e->src[5]);
  
    printf("Type %hd\n", eth->type);
    hexview(buffer, size);
}
*/

unsigned short htons(unsigned short n) {               // Host short to network shor
  return ((n & 0xff) << 8) | ((n & 0xff00) >> 8);      // Byte swapping
}

void show(char *buf, int size) {
    printf("Destination:  %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n",
            buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
    printf("Source: %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n",
            buf[6], buf[7], buf[8], buf[9], buf[10], buf[11]);
  
    printf("Type %hd\n", htons((short)buf[12]));
    
    hexview(buf, size);
}


int main() {
    char buffer[0x600];
    int size = 0;
    
    while(1) {
        if((size = eth.receive()) != 0) {
            eth.read(buffer, size);
            show(buffer, size);
        }
        
        led4 = 1;
        wait(0.2);
        led4 = 0;
        wait(0.2);
    }
}
