/* mbed Ethernet class demo
 * Copyright (c) 2009 rmeyer
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "hexview.h"

DigitalOut led(LED4);
Ethernet eth;

unsigned short htons(unsigned short n) {               // Host short to network shor
  return ((n & 0xff) << 8) | ((n & 0xff00) >> 8);      // Byte swapping
}

void show(char *buf, int size) {
    printf("ETH:  Src:  %02hX:%02hX:%02hX:%02hX:%02hX:%02hX  ",
            buf[6], buf[7], buf[8], buf[9], buf[10], buf[11]);
    printf("Dst:  %02hX:%02hX:%02hX:%02hX:%02hX:%02hX   ",
            buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
  
    unsigned int type = (buf[12] << 8) | (buf[13]);
    printf("Type: %hd\n", htons( type));
    
    hexview2(buf, size);
}


int main() {
    char buffer[0x300];
    int size = 0;
    
    while(1) {
        if((size = eth.receive()) != 0) {
            eth.read(buffer, size);
            show(buffer, size);
        }
        
        led = !led;
        wait(0.2);
    }
}
