#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);
CAN can1(p9, p10);
CAN can2(p30, p29);

int main() {
    char count = 0;
    CANMessage msg;
    
    while(1) {
        if(can1.write(CANMessage(0x42, &count, 1))) {
            led1 = 1;
        }
        
        if(can2.read(msg)) {
            if(count == msg.data[0]) {
                led2 = !led2;
                count++;
            }
        } 
        
        wait(0.2);
        led1 = led2 = 0;
        led4 = !led4;
    }
}

/*
                     ___                                 (NXP TJA 1050)
            ____+---|| ||---+                  mbed     TJA1     TJA2
           |    |:  |_v_|  :|____              ----------------------
          GND   |: m  =  w :|    |             VV       Vcc      Vcc
           |    |:   ---   :|   VV(5.0V)       GND      GND      GND
           |    |:  I O I  :|    |             p9       RXD      -
           | +-=|:   ---   :|    |             p10      TXD      -
           | | ||: +-----+ :|=-+ |             p29      -        TXD
           | | ||: |     | :|| | |             p30      -        RXD
           | | ||: |     | :|| | |             -        CANL     CANL
           | | ||: +-----+ :|| | |             -        CANH     CANH
           | | ||: = = = = :|| | |
    _____  | | |+-----------+| | |
   |/TJA |-|-+ |             | | |
+--|/1050|-|---|-------------|-|-+ 
| +|/    |-+   |             | | |
| ||/____|-|---+             | | |
| | _____  |                 | | |
| ||/TJA |-|-----------------+ | |
+-||/1050|-|-------------------|-+
  +|/    |-+                   |
   |/____|---------------------+
    ^-- rounded side
*/
