#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define MAXBLINKSPEED 0.8

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    
    float x_data, y_data;
    float x_ref = 0.05f;
    float y_ref = 0.05f;
    
    printf("MMA8451 ID: %d\n", acc.getWhoAmI()); //acts as a reset message

    while (true) {
        x_data = acc.getAccX(); // detect pitch
        y_data = acc.getAccY(); //detect roll
        
        if(abs(x_data) > x_ref)
        {
            gled = 1.0f;
            printf("Pitch detected !!!\n");
            wait(MAXBLINKSPEED * abs(x_data)); //speed of blinking changes depending on pitch position
            gled = 0.0f;
        }
        if(abs(y_data) > y_ref)
        {
            rled = 1.0f;
            printf("Roll detected !!!\n");
            wait(MAXBLINKSPEED * abs(y_data)); //speed of blinking changes depending on roll position
            rled = 0.0f;
        }
        if(abs(x_data) == x_ref && abs(y_data) == y_ref)
        {
            printf("Board is leveled !!!\n");
        }
        printf("X: %.2f, Y: %.2f\n", x_data, y_data);
        
    }
}
