#include "mbed.h"
#include "AD9833.h"
#include "AD9850.h"

AD9833 gen;       // AD9833 object. Defaults to 25MHz internal reference frequency
AD9850 dds;       // AD9850 object.

DigitalOut GENLED(PC_7);         //LED for AD9833 output
DigitalOut DDSLED(PC_13);        //LED for AD9850 output

double GENfreq = 10000;            //frequency for the AD9833
double DDSfreq = 10000;         //frequency for the AD9850
double DDStrimFreq = 124999500;    //frequency used by AD9850 to calibrate
int DDSphase = 0;                  //phase for the AD9850

Thread GENthread;                   //create thread to allow simultaneous LED blink and DDS output
Thread LEDthread; 

//AD9833 LED thread
void GENBlinkThread() {
    while (true) {
        GENLED = !GENLED;
        if(GENfreq != DDSfreq){
            Thread::wait(1000/GENfreq);     
        }else{
            Thread::wait(1500/GENfreq);   //changed the thread wait time so that it will not equal the other thread
        }
    }
}

//AD9850 LED thread
void DDSBlinkThread() {
    while (true) {
        DDSLED = !DDSLED;
        Thread::wait(1000/DDSfreq);
    }
}

int main() { 

    GENthread.start(callback(GENBlinkThread));
    LEDthread.start(callback(DDSBlinkThread));
   
    // Sequence to follow to generate waveform using AD9833
    gen.Begin();              // The loaded defaults are 1000 Hz SINE_WAVE using REG0
                             // The output is OFF, Sleep mode is disabled
    gen.EnableOutput(false);  // Turn ON the output
    WaveformType waveType = SINE_WAVE;    //set waveform type. other possible value: TRIANGLE_WAVE, SQUARE_WAVE, HALF_SQUARE WAVE
    gen.SetWaveform(REG0,waveType);       //set wave type to register
    gen.SetGENFrequency(REG0,GENfreq);    //set frequency to register 
    gen.SetOutputSource(REG0);            //output waveform with GENfreq as frequency
    
    // Sequence to follow to generate waveform using AD9850
    dds.Begin();                         //begin generating for the AD9850
    dds.CalibrateDDS(DDStrimFreq);       //calibrate to match crystal oscillator
    dds.SetDDSFrequency(DDSfreq, DDSphase);
    
    GENthread.join();                   //wait for the threads to finish
    LEDthread.join();
    while(1);
}
