// FT5206.h für FT5206.cpp
// Roland Fuchs

#include "mbed.h"
/*
//-- Tastatur
#define Hoch   20
#define Tief   21
#define Rechts 22
#define Links  23
#define Ja     24
#define Weg    25
*/
struct Tip
{
    int x[5];
    int y[5];
}; // 40 Bytes


void init_FT5206();
int  getTip5(Tip*);
int  getTip(int *x,int *y);
int  getTipPoll(int *x,int *y);
void getTipWait(int ms);

void tip_irq_ein();
void tip_irq_aus();

void writeReg8(char reg,char val);
char readReg8(char reg);
int  readReg16(char reg);


/** This is a library to handling capacitive multitouch sensors using FT5206.
 * FT5206 Capatitive Touch Panel driver for 7 inch BuyDisplay LCD, with 5-point touch
 * http://www.buydisplay.com/default/7-inch-lcd-module-capacitive-touch-screen-panel-i2c-spi-serial
 *
 * Example:
 * @code
 *  // Use of the capacitive touch panel
 *  #define PIN_SCL_FT5206  D15
 *  #define PIN_SDA_FT5206  D14
 *  #define PIN_INT_FT5206  D7
 *  FT5206 FT5206(PIN_SDA_FT5206, PIN_SCL_FT5206, PIN_INT_FT5206); // sda, scl, int
 *  FT5206.init();
 *  while(1)
 *  {
 *      if(FT5206.getPanelTouched())
 *      {
 *          for (int i = 0; i < FT5206.numberOfTouchPoints; i++)
 *              printf("Coord %d: %d, %d  \r\n", i+1, FT5206.touchCoordinatesX[i], FT5206.touchCoordinatesY[i]);
 *      }
 *  }
 * @endcode
 *
 */

/*
#define DEBUG_OUTPUT_ENABLED                false
#define FT5206_I2C_FREQUENCY                400000

// FT5206 definitions 
#define FT5206_I2C_ADDRESS                  0x38
#define FT5206_NUMBER_OF_REGISTERS          31     // there are more registers, but this
                                            // is enought to get all 5 touch coordinates.

#define FT5206_NUMBER_OF_TOTAL_REGISTERS    0xFE

#define FT5206_DEVICE_MODE                  0x00
#define FT5206_GEST_ID                      0x01

#define TD_STATUS                    0x02 // How many points detected (3:0). 1-5 is valid.

#define TOUCH1_XH                    0x03 // Event Flag, Touch X Position
#define TOUCH1_XL                    0x04
#define TOUCH1_YH                    0x05 // Touch ID, Touch Y Position
#define TOUCH1_YL                    0x06

#define TOUCH2_XH                    0x09 // Event Flag, Touch X Position
#define TOUCH2_XL                    0x0a
#define TOUCH2_YH                    0x0b // Touch ID, Touch Y Position
#define TOUCH2_YL                    0x0c

#define TOUCH3_XH                    0x0f // Event Flag, Touch X Position
#define TOUCH3_XL                    0x10
#define TOUCH3_YH                    0x11 // Touch ID, Touch Y Position
#define TOUCH3_YL                    0x12

#define TOUCH4_XH                    0x15 // Event Flag, Touch X Position
#define TOUCH4_XL                    0x16
#define TOUCH4_YH                    0x17 // Touch ID, Touch Y Position
#define TOUCH4_YL                    0x18

#define TOUCH5_XH                    0x1b // Event Flag, Touch X Position
#define TOUCH5_XL                    0x1c
#define TOUCH5_YH                    0x1d // Touch ID, Touch Y Position
#define TOUCH5_YL                    0x1e

#define FT5206_ID_G_THGROUP                 0x80 // Valid touching detect threshold
#define FT5206_ID_G_THPEAK                  0x81 // Valid touching peak detect threshold
#define FT5206_ID_G_THCAL                   0x82 // The threshold when calculating the focus of touching
#define FT5206_ID_G_THWATER                 0x83 // The threshold when there is surface water
#define FT5206_ID_G_THTEMP                  0x84 // The threshold of temperature compensation
#define FT5206_ID_G_CTRL                    0x86 // Power control mode
#define FT5206_ID_G_TIME_ENTER_MONITOR      0x87 // The timer of entering monitor status
#define FT5206_ID_G_PERIODACTIVE            0x88 // Period Active
#define FT5206_ID_G_PERIODMONITOR           0x89 // The timer of entering idle while in monitor status
#define FT5206_ID_G_AUTO_CLB_MODE           0xA0 // Auto calibration mode

#define FT5206_TOUCH_LIB_VERSION_H          0xA1 // Firmware Library Version H byte
#define FT5206_TOUCH_LIB_VERSION_L          0xA2 // Firmware Library Version L byte
#define FT5206_ID_G_CIPHER                  0xA3 // Chip vendor ID
#define FT5206_G_MODE                       0xA4 // The interrupt status to host
#define FT5206_ID_G_PMODE                   0xA5 // Power Consume Mode
#define FT5206_FIRMID                       0xA6 // Firmware ID
#define FT5206_ID_G_STATE                   0xA7 // Running State
#define FT5206_ID_G_FT5201ID                0xA8 // CTPM Vendor ID
#define FT5206_ID_G_ERR                     0xA9 // Error Code
#define FT5206_ID_G_CLB                     0xAA // Configure TP module during calibration in Test Mode
#define FT5206_ID_G_B_AREA_TH               0xAE // The threshold of big area
#define FT5206_LOG_MSG_CNT                  0xFE // The log MSG count
#define FT5206_LOG_CUR_CHA                  0xFF // Current character of log message, will point to the next
                                               // character when one character is read.

#define FT5206_GEST_ID_MOVE_UP              0x10
#define FT5206_GEST_ID_MOVE_LEFT            0x14
#define FT5206_GEST_ID_MOVE_DOWN            0x18
#define FT5206_GEST_ID_MOVE_RIGHT           0x1c
#define FT5206_GEST_ID_ZOOM_IN              0x48
#define FT5206_GEST_ID_ZOOM_OUT             0x49
#define FT5206_GEST_ID_NO_GESTURE           0x00

#define FT5206_EVENT_FLAG_PUT_DOWN          0x00
#define FT5206_EVENT_FLAG_PUT_UP            0x01
#define FT5206_EVENT_FLAG_CONTACT           0x02
#define FT5206_EVENT_FLAG_RESERVED          0x03

#define FT5206_ID_G_POLLING_MODE            0x00
#define FT5206_ID_G_TRIGGER_MODE            0x01

#define FT5206_ID_G_PMODE_ACTIVE            0x00
#define FT5206_ID_G_PMODE_MONITOR           0x01
#define FT5206_ID_G_PMODE_HIBERNATE         0x03

#define FT5206_ID_G_STATE_CONFIGURE         0x00
#define FT5206_ID_G_STATE_WORK              0x01
#define FT5206_ID_G_STATE_CALIBRATION       0x02
#define FT5206_ID_G_STATE_FACTORY           0x03
#define FT5206_ID_G_STATE_AUTO_CALIBRATION  0x04

class FT5206
{
public:
    FT5206(PinName sda, PinName scl, PinName interrupt);

    void init();
    int  getTouchPositions();
    void intPanelTouched();
    bool getPanelTouched();

    int tipanz;//numberOfTouchPoints;
    int tipx[5];//touchCoordinatesX[5];
    int tipy[5];//touchCoordinatesY[5];

private:
    InterruptIn m_interrupt;

    I2C m_i2c;
    //int m_addr;
    char data[2];

    bool debug_output_enabled;
    bool panelTouched;
    void writeRegister8(char reg, char val);
    char readRegister8(char reg);

};
*/