// FT5206.cpp
// Roland Fuchs

#include "FT5206.h"
#include "fuchs.h"

#define I2C_ADR    0x38
#define TD_STATUS  0x02 // How many points detected (3:0). 1-5 is valid.

#define T1_X       0x03 // 1 Event Flag, Touch X Position
#define T2_X       0x09 // 2
#define T3_X       0x0f // 3
#define T4_X       0x15 // 4
#define T5_X       0x1b // 5


extern I2C         ft_i2c;   // (p9,p10);   //SDA,SCL Tip
extern InterruptIn ft_irq;   // (p16);

extern DigitalOut led1;//(LED1);

//---------------------------------------------------------------

void init_FT5206()
{
    ft_i2c.frequency(400000); // 400kHz=Standard (FT5206_I2C_FREQUENCY);
    // Interrupt
    ft_irq.fall(&tip_irq_ein);
    ft_irq.rise(&tip_irq_aus);
    //#define FT5206_DEVICE_MODE 0x00
    writeReg8(0x00,0);
    wait(0.1);
}

int getTip5(Tip *zt)
{
    Tip Tx=*zt;
    int tipanz=readReg8(TD_STATUS) & 0xF;
    if(tipanz>5) tipanz=5;
    char adr[5]={T1_X,T2_X,T3_X,T4_X,T5_X}; // TOUCH1_XH.......
    for(int i=0; i<5; i++)
    {
        Tx.x[i]=Tx.y[i]=-1;
        if(i<tipanz)
        {    
            Tx.x[i]=readReg16(adr[i]);//(readReg8(adr[i]  ) & 0x0f)*256+readReg8(adr[i]+1);
            Tx.y[i]=readReg16(adr[i]+2);//(readReg8(adr[i]+2) & 0x0f)*256+readReg8(adr[i]+3);
        }
    }
    *zt=Tx;
klick(1);
    return tipanz;
}

int getTip(int *x,int *y)
{   // wartet auf 1. Tip
    int tipanz=0;
    char adr=T1_X;
    do
        tipanz=readReg8(TD_STATUS) & 0xF;
    while(tipanz==0);
klick(1);
    *x=readReg16(adr);//(readReg8(adr  ) & 0x0f)*256+readReg8(adr+1);
    *y=readReg16(adr+2);//(readReg8(adr+2) & 0x0f)*256+readReg8(adr+3);
    return tipanz;
}

int getTipPoll(int *x,int *y)
{   // wartet nicht auf Tip !!!!!
    char adr=T1_X;
    *x=*y=0;
    int tipanz=readReg8(TD_STATUS) & 0xF;
    if(tipanz>0)
    {
        *x=readReg16(adr);//(readReg8(adr  ) & 0x0f)*256+readReg8(adr+1);
        *y=readReg16(adr+2);//(readReg8(adr+2) & 0x0f)*256+readReg8(adr+3);
klick(1);
    }
    return tipanz;
}

void getTipWait(int ms)
{   // wartet vorher ms millisekunden
    wait_ms(ms);
    while( (readReg8(TD_STATUS) & 0xF)==0);
klick(1);
}

void tip_irq_ein()
{
    led1=1;//piep(1000,0.1);    
}

void tip_irq_aus()
{
    led1=0;//piep(1000,0.1);    
}

char readReg8(char reg)
{
    char val;
    ft_i2c.write(I2C_ADR << 1,&reg,1);
    ft_i2c.read( I2C_ADR << 1,&val,1);
    return val;
}

void writeReg8(char reg,char val)
{
    char data[2]={reg,val};
    ft_i2c.write(I2C_ADR,data,2);
}

int readReg16(char reg)
{
    char val1,val2;
    ft_i2c.write(I2C_ADR << 1,&reg,1);
    ft_i2c.read( I2C_ADR << 1,&val1,1);
    reg++;
    ft_i2c.write(I2C_ADR << 1,&reg,1);
    ft_i2c.read( I2C_ADR << 1,&val2,1);
    return (int)(256*(val1 & 0x0f)+val2);
}

/*
FT5206::FT5206(PinName sda, PinName scl, PinName interrupt) : m_i2c(sda, scl), m_interrupt(interrupt)
{
    //m_addr = (FT5206_I2C_ADDRESS << 1);
    m_i2c.frequency(400000);//(FT5206_I2C_FREQUENCY);

    // Interrupt
    m_interrupt.mode(PullUp);
//-----------------------------------------------
// Roli 14.3.17 InterruptIn has no member enable_irq()
//    m_interrupt.enable_irq();
//-----------------------------------------------
    m_interrupt.fall(this, &FT5206::intPanelTouched);

    init();
}

void FT5206::init(void)
{
    panelTouched = false;

//    if(DEBUG_OUTPUT_ENABLED) printf("Trying to initialize FT5206 by I2C\r\n");
    //#define FT5206_DEVICE_MODE                  0x00
    writeRegister8(0x00,0);

    for(int i=0; i<5; i++)
    {
        tipx[0]=-1;
        tipy[0]=-1;
    }

//    if(DEBUG_OUTPUT_ENABLED) printf("Setup done.\r\n");
}

int FT5206::getTouchPositions()
{
    tipanz = readRegister8(FT5206_TD_STATUS) & 0xF;

    for (int i = 0; i < 5; i++)
    {
        tipx[0] = -1;
        tipy[0] = -1;
    }
    if (tipanz > 0)
    {
        tipx[0] = (readRegister8(FT5206_TOUCH1_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH1_XL);
        tipy[0] = (readRegister8(FT5206_TOUCH1_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH1_YL);
    }
    if (tipanz > 1)
    {
        tipx[1] = (readRegister8(FT5206_TOUCH2_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH2_XL);
        tipy[1] = (readRegister8(FT5206_TOUCH2_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH2_YL);
    }
    if (tipanz > 2)
    {
        tipx[2] = (readRegister8(FT5206_TOUCH3_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH3_XL);
        tipy[2] = (readRegister8(FT5206_TOUCH3_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH3_YL);
    }
    if (tipanz > 3)
    {
        tipx[3] = (readRegister8(FT5206_TOUCH4_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH4_XL);
        tipy[3] = (readRegister8(FT5206_TOUCH4_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH4_YL);
    }
    if (tipanz > 4)
    {
        tipx[4] = (readRegister8(FT5206_TOUCH5_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH5_XL);
        tipy[4] = (readRegister8(FT5206_TOUCH5_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH5_YL);
    }
    return tipanz;
}


// Interrupt for touch detection
void FT5206::intPanelTouched()
{
    getTouchPositions();
    panelTouched = true;
}

bool FT5206::getPanelTouched()
{
    if(panelTouched==true)
    {
        panelTouched=false;
        return true;
    }
    else
        return false;
}

char FT5206::readRegister8(char reg)
{
    char val;
    m_i2c.write(FT5206_I2C_ADDRESS << 1, &reg, 1);
    m_i2c.read(FT5206_I2C_ADDRESS << 1, &val, 1);
    return val;
}

void FT5206::writeRegister8(char reg, char val)
{
    char data[2];
    data[0] = reg;
    data[1] = val;
    m_i2c.write((int)FT5206_I2C_ADDRESS, data, 2);
}
*/