//Project coded by Vikash Ramkumar and Rohith Kondeti
//Property of Georgia Institute of Technology

/******************************************************
*               The Proximity Sensor Game
* Rules of the Game:
* 1. Get your hand to match what the sensor indicates. A 20 will mean that the your hand needs to be close to the sensor. A 50 will mean that your hand needs to be farther away. 
* 2. The goal is to reach 5 points.
* 3. Once you hit 5 points, your time will be shown on the LCD. Challenge your friends to see who gets the lowest score!
******************************************************/

#include "mbed.h"
#include "SHARPIR.h"
#include "uLCD_4DGL.h"
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>     /* srand, rand */


DigitalOut myled1(p21);
DigitalOut myled2(p22);
DigitalOut myled3(p23);
DigitalOut myled4(p24);
DigitalOut myled5(p25);
//DigitalOut myled6(p28);    // not CORRECT // waiting - can blink faster and faster until times up (steady)
DigitalOut myled6(p26);    // CORRECT
Timer t;

uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object

SHARPIR Sensor(p18); //the output of the sharpIR sensor is connected to the MBEDs pin 10.

int main() {
    float DistanceCM;
    float v1, score =-1, checkLed6;
    t.start();
    while (1) { //creates an eternal loop
        myled6 = 0;
        checkLed6 = 0;
        DistanceCM=Sensor.cm();  //this will 
        srand(DistanceCM);     // v2 in the range 20 to 50
        v1 = rand() % 30 + 20;     // v2 in the range 20 to 50
    
        score++;// score increases each time around
       if(score >4)
        {
             
             t.stop();
             uLCD.cls();
             while(1)
             {
              
                 uLCD.locate(1,5);
                uLCD.printf("You won in %.1fs!\n", t.read());
                 
             }
        }
        while(checkLed6 < 8)
        {
            DistanceCM=Sensor.cm();
            uLCD.locate(1,2);
            uLCD.printf("%.1f and %.1f \n", v1, DistanceCM);
            uLCD.locate(1,3);
            uLCD.printf("Score so far: %.1f \n", score);
            
            
            if(abs(DistanceCM-v1) <5)
            {
                myled1 = 1;
                myled2 = 1;
                myled3 = 1;
                myled4 = 1;
                myled5 = 1;
                myled6 = 1;
                
                checkLed6++;
            }
            else if((abs(DistanceCM-v1) >5) &&(abs(DistanceCM-v1) <10) )
            {
                myled1 = 1;
                myled2 = 1;
                myled3 = 1;
                myled4 = 1;
                myled5 = 0;
                myled6 = 0;
                checkLed6 =0;
            }
            else if((abs(DistanceCM-v1) >10) &&(abs(DistanceCM-v1) <15) )
            {
                myled1 = 1;
                myled2 = 1;
                myled3 = 1;
                myled4 = 0;
                myled5 = 0;
                myled6 = 0;
                checkLed6 =0;
            }
            else if((abs(DistanceCM-v1) >15) &&(abs(DistanceCM-v1) <20) )
            {
                myled1 = 1;
                myled2 = 1;
                myled3 = 0;
                myled4 = 0;
                myled5 = 0;
                myled6 = 0;
                checkLed6 =0;
            }
            
            else if((abs(DistanceCM-v1) >20) &&(abs(DistanceCM-v1) <25) )
            {
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                myled5 = 0;
                myled6 = 0;
                checkLed6 =0;
            }
            else
            {
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                myled5 = 0;
                myled6 = 0;
                checkLed6 =0;
            }
         
        }
        
        wait_ms(20); //wait 20 ms between each readout
    }
}
