#include "mbed.h"

//Enable serial communication
Serial pc(USBTX, USBRX); // tx, rx

//Timers used to model the pacemaker
Timeout AVI;
Timeout PVARP;
Timeout LRI;

//Pins used to communicate with the heart, P9 is AP, P10 is VP, P11 is AS and P12 is VS
DigitalOut pinAP(p9);
DigitalOut pinVP(p10);
InterruptIn pinAS(p11);
InterruptIn pinVS(p12);

//Reference LEDs
DigitalOut vs(LED1);
DigitalOut vp(LED2);
DigitalOut as(LED3);
DigitalOut ap(LED4);

//Pacemaker values in seconds;
float lri = 1.0;
float pvarp = 0.3;
float vrp = 0.2;
float pvab = 0.05;
float pavb = 0.05;
float avi = 0.15;

//Initial states
int vsValid = 1;
int asValid = 1;

//Interrupt function prototypes
void ASReceivedOrAPSent();
void VSReceviedOrVPSent();
void noVentricleEvent();
void noAtrialEvent();
void postPVARP();
void blinkled();

//Interrupt routines for all pacemaker states

//Interrupt routine to handle atrial event
void ASReceivedOrAPSent() {
    if(asValid==1) {
        /*as = 1;
        wait(0.2);
        as = 0;*/
        //Disable the LRI timer as a AS has been received
        LRI.detach();
        //Disable the PVARP timer as a AS has been recieved
        PVARP.detach();
        //Make asValid=0 and vsValid=0
        asValid = 0;
        vsValid = 0;
        //Set up timer to interrupt at AVI and call noVentricleEvent if no ventricular event comes
        AVI.attach(&noVentricleEvent, avi);
        //Wait for PAVB and disable all interrupts
        __disable_irq();
        wait(pavb);
        //After waiting for PAVB enable interrupts and make asValid=0 and vsValid=1
        __enable_irq();
        asValid = 0;
        vsValid = 1;
    }
}

//Interrupt routine to handle atrial event
void VSReceivedOrVPSent() {
    if(vsValid==1) {
        /*vs = 1;
        wait(0.2);
        vs = 0;*/
        //Disable the AVI timer as VS has been recieved.
        AVI.detach();
        asValid = 0;
        vsValid = 0;
        //Set up timer to interrupt at PVARP
        PVARP.attach(&postPVARP, pvarp);
        //Set up timer to interrupt at LRI-AVI
        LRI.attach(&noAtrialEvent, lri-avi);
        //Wait for VRP and disable all interrupts
        __disable_irq();
        wait(vrp);
        //After waiting for VRP enable interrupts make asValid = 0 and vsValid = 1
        __enable_irq();
        asValid = 0;
        vsValid = 1;
    }
}

//Interrupt routine to handle post AVI scenario when no VS is receieved
void noVentricleEvent() {
    //Pace heart now, ventricle!
    pinVP = 1;
    wait(0.01);
    pinVP = 0;
    //Call VSReceiedOrVPSent()
    VSReceivedOrVPSent();     
}

//Interrupt routine to hande scenario when no AS or VS is recevied till PVARP
void postPVARP() {
    vsValid = 1;
    asValid = 1;
    //Disable the PVARP timer as a AS has been recieved
    PVARP.detach();
    //Set up timer to interrupt at LRI-AVI-PVARP
    LRI.attach(&noAtrialEvent, lri-avi-pvarp);
}


//Interruot routine to handle scenarios when there is no Atrial event
void noAtrialEvent() {
    //Pace heart now, atrial!
    pinAP = 1;
    wait(0.01);
    pinAP = 0;
    ASReceivedOrAPSent();
}

/*void blinkled() {
    vs=1;
    wait(0.2);
    vs=0;
}*/

int main() {
    //Pins used to communicate with the heart
    //P11 is AS and P12 is VS
    pinAS.rise(&ASReceivedOrAPSent);
    pinVS.rise(&VSReceivedOrVPSent);
    __enable_irq();
    while(1) {
    }
}
