#include "mbed.h"
#include "stdio.h"
#include "WIZnetInterface.h"

unsigned char MAC_Addr[6] = {0x90,0x08,0xDC,0x12,0x07,0x07};

char* Update_Key = "L055HRYFCBL1LTM2";
char* ServerIP = "api.thingspeak.com";
int Count = 15;

SPI spi(PTD2,PTD3,PTD1);
WIZnetInterface ethernet(&spi,PTD0,PTA1);

Serial pc(USBTX, USBRX);
Serial micro(PTE0, PTE1); // tx, rx

char buff[]={'\0'};

AnalogIn ax(PTC1);
AnalogIn ain(PTC2);


BusOut SevSeg1(PTD4,PTA12,PTA4,PTA5);
BusOut SevSeg2(PTC8,PTC9,PTA13,PTD5); 

//DigitalOut toutb(PTA1);
PwmOut ledout(LED1);

float luxm(void)
{
    float vr=0;
    float lr=0;
    float vol[14]={0,1.1,1.23,1.3,1.45,1.6,1.81,2.06,2.31,2.62,2.81,3.02,3.1,3.3};
    float lux[14]={27000,20000,16000,11000,7000,4000,1500,833,578,201,104,40,23,0};

    int i;
    float m=0;

    vr=ain*3.3;

    for(i=0; vr> vol[i];i++);
    m = ((lux[i]-lux[i-1])/(vol[i]-vol[i-1]));
    lr=lux[i-1]+(m*(vr-(vol[i-1])));

    return lr;
}


uint8_t val,val1;

int main() 
{
    pc.printf("Start\r\n");
        
    do
    {
        int ret = ethernet.init(MAC_Addr);
        
        if (!ret) 
        {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) 
            {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
                          val=0x00;
            } 
            else 
            {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                val=0xff;
            }
        
        } 
        else 
        {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            val=0xff;;
        }
    }while(val==0xff);
    
    TCPSocketConnection sock;       
    do
    {   
        sock.connect("api.thingspeak.com", 80);
        if(sock.is_connected())
            {
                pc.printf("Socket Connected\n\r");
                val=0x00;
            }
        else
            {
                pc.printf("Socket NoT Connected\n\r");
                val=0xff;
            }
            
    }while(val==0xff);
        
    char buffer[300];
    int ret_t;
    char http_cmd[256]; 
    
    int i;
    int j=0;
    while(1) 
    { 
                
    
        do
        {   
            for(i=j;i<60;i++)
            {
                float l=ain;
                float t=ax;
                
                ledout=1.0-l;
       
                if(l>=0 && l<0.25)
                    SevSeg1 = 0x00;  
                else if (l>=0.25 && l<0.50)
                    SevSeg1 = 0x01          ;  
                else if (l>=0.50 && l<0.75)
                    SevSeg1 = 0x03;  
                else if (l>=0.75 && l<=1.0)
                    SevSeg1 = 0x07;  
                
                if(t<0.5050)
                    SevSeg2 = 0x00;  
                else if (t>=0.5050 && t<0.5070)
                    SevSeg2 = 0x01          ;  
                else if (t>=0.5070)
                    SevSeg2 = 0x03;  

                    
                        
                if(micro.readable()) 
                {
                   val=(micro.getc());
                   j=i;
                   i=25;                   
                }
           
                else
                    wait(1);
            }
        
            TCPSocketConnection sock;       
            do
            {   
            sock.connect("api.thingspeak.com", 80);
            if(sock.is_connected())
            {
                pc.printf("Socket Connected\n\r");
                val1=0x00;
            }
            else
            {
                pc.printf("Socket NoT Connected\n\r");
                val1=0xff;
            }
            
            }while(val1==0xff);
    
            if(val == 0x00)
            {
                pc.printf("%.2f ",luxm());
                
                sprintf(http_cmd,"GET /update?key=L055HRYFCBL1LTM2&field1= %.2f HTTP/1.0\n\n",luxm());
                printf("Running - %s\r\n",http_cmd);
                sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
                ret_t = sock.receive(buffer, sizeof(buffer)-1);
                buffer[ret_t] = '\0';
                printf("Received %d chars from server:\n%s\r\n", ret_t, buffer);

                
                pc.printf("%.2f ",ax*3.3*17);
    
                sprintf(http_cmd,"GET /update?key=L055HRYFCBL1LTM2&field2= %.4f HTTP/1.0\n\n",ax*3.3*17/2);
                printf("Running - %s\r\n",http_cmd);
                sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
                ret_t = sock.receive(buffer, sizeof(buffer)-1);
                buffer[ret_t] = '\0';
                printf("Received %d chars from server:\n%s\r\n", ret_t, buffer);
                val=0x00;
                j=0;
            }
            else if(val == 0x01)
            {  
                pc.printf("%.2f ",luxm());
          
                sprintf(http_cmd,"GET /update?key=L055HRYFCBL1LTM2&field1= %.2f HTTP/1.0\n\n",luxm());
                printf("Running - %s\r\n",http_cmd);
                sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
                ret_t = sock.receive(buffer, sizeof(buffer)-1);
                buffer[ret_t] = '\0';
                printf("Received %d chars from server:\n%s\r\n", ret_t, buffer);
                val=0x00;
            }

            else if(val == 0x02)
            {      
                pc.printf("%.2f ",ax*3.3*17);
    
                sprintf(http_cmd,"GET /update?key=L055HRYFCBL1LTM2&field2= %.4f HTTP/1.0\n\n",ax*3.3*17/2);
                printf("Running - %s\r\n",http_cmd);
                sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
                ret_t = sock.receive(buffer, sizeof(buffer)-1);
                buffer[ret_t] = '\0';
                printf("Received %d chars from server:\n%s\r\n", ret_t, buffer);
                val=0x00;
            }
        }while(val==0x00);
    
    } 
       
    //sock.close();
    
    //ethernet.disconnect();
    //printf("Socket Closed");
}       
  
 //        float x=ain;
        //led=x;