#include "mbed.h"
#include "ds1307.h"
#include "TM1636.h"

// New infos are ready

DigitalOut myled(D2);
DigitalIn  button_K1(D9);

Serial pc(USBTX, USBRX);                        // tx, rx  for debug and usb pc comunications

DS1307 my1307(I2C_SDA, I2C_SCL);                // DS1307 Objekt für Zugriff auf RTC auf Shield (Pins I2C)
                                                // Verbindung zwischen Shield und Nucleo A4-D14 und A5-D15 zwingend nötig
                                                
TM1636 tm1636(D7,D8);                           // Display driver for 7-Segment-Display
 
int sec = 0;
int min = 0;
int hours = 0;
int day = 0;
int date = 0;
int month = 0;
int year = 0;

int8_t temp[4];

void test_rw(int test) {
    if (test == 0) {
        // pc.printf("Last R/W operaion passed!\n\r");
    }
    else {
        pc.printf("Last R/W operation failed!\n\r");
    }
}


int main() {
     
    button_K1.mode(PullUp);
    tm1636.init();
    int junk = 0;

    while(1){
         
        if (!button_K1)
        {
            test_rw(my1307.settime( 00, 35, 12, 3, 17, 5, 17));
            pc.printf("time is set to 12:00:00 - 17.05.2017\n\r");
            
            junk = 0x39;                                                // just a junk value do read and write test to DS1307 ram
            test_rw(my1307.write( 0x20, junk));                         // this should write the value of junk to register 0x20 (a ram location) in the ds1307.
            pc.printf("Value written to register 0x20 %.2X \n\r",junk);
        }
        else
        {
            test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
            pc.printf("time is %.2D.%.2D.%.2D - %.2D-%.2D-20%.2D \r", hours, min, sec, date, month, year);
            
            temp[0] = hours / 10;
            temp[1] = hours % 10;
            temp[2] = sec / 10;
            temp[3] = sec % 10;                   
            tm1636.display(temp);       
        
            //junk = 0;                                                   // clear junk to show that when the register is read from the correct value is obtained
            //test_rw(my1307.read( 0x20, &junk));                         // this should read register 0x20
            //pc.printf("Value read from register 0x20 %.2X \n\r",junk);
        }
        if ((sec % 2 == 1))
        {
            //tm1636.point(POINT_ON);
        }
        else
        {
            //tm1636.point(POINT_OFF);
        } 
        wait(1.0);
        myled = ! myled;
    }
}
