#include "mbed.h"
#include "ShiftOut.h"

ShiftOut Seg7(D8, D7, D4, D13, D12);

const char SEGMENT_MAP[] = {0x03,0x9F,0x25,0x0D,0x99,0x49,0x41,0x1F,0x01,0x09};
const char SEGMENT_SELECT[] = {0x8F,0x4F,0x2F,0x1F};

int counter = 0;

int main() {
    while(1) {
        for (int delay = 0 ; delay < 100 ; delay++) {
            Seg7.write2Byte(SEGMENT_MAP[counter/1000] + (SEGMENT_SELECT[0]<<8));
            Seg7.write2Byte(SEGMENT_MAP[counter%1000/100] + (SEGMENT_SELECT[1]<<8));
            Seg7.write2Byte(SEGMENT_MAP[counter%100/10] + (SEGMENT_SELECT[2]<<8));
            Seg7.write2Byte(SEGMENT_MAP[counter%10] + (SEGMENT_SELECT[3]<<8));
        }
        if (counter < 9999) {
            counter++;
        } else {
            counter = 0;
        }
    }
}
