/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "ShiftOut.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500

ShiftOut Seg7(D8, D7, D4, D13, D12);

const char SEGMENT_MAP[] = {0x03,0x9F,0x25,0x0D,0x99,0x49,0x41,0x1F,0x01,0x09,0xFF,0x63};
const char SEGMENT_SELECT[] = {0x8F,0x4F,0x2F,0x1F};

Thread Thread1;
Thread Thread2;

AnalogIn    adc_temp(A4);               

int TempMittelwert = 200;

void Anzeige_Thread(void)
{
    while (1)
    {
        Seg7.write2Byte(SEGMENT_MAP[TempMittelwert/100] + (SEGMENT_SELECT[0]<<8));
        ThisThread::sleep_for(1);
        Seg7.write2Byte(SEGMENT_MAP[TempMittelwert%100/10] + (SEGMENT_SELECT[1]<<8)& 0xFFFE);
        ThisThread::sleep_for(1);
        Seg7.write2Byte(SEGMENT_MAP[TempMittelwert%10] + (SEGMENT_SELECT[2]<<8));
        ThisThread::sleep_for(1);
        Seg7.write2Byte(SEGMENT_MAP[11] + (SEGMENT_SELECT[3]<<8));
        ThisThread::sleep_for(1);
    }
}

void Messung_Thread(void)
{
    float Temperatur;
    while (1)
    {
        Temperatur = (float)(3300 * adc_temp.read() - 2637) / -13.6;
        TempMittelwert = (int)(Temperatur - 20) * 10;
        ThisThread::sleep_for(10);
    }
}

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    
    Thread1.start(Anzeige_Thread);             // Thread starten
    Thread2.start(Messung_Thread);             // Thread starten

    while (true) {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
