#ifndef COUNTER_H
#define COUNTER_H

#include "mbed.h"
#include "FreescaleIAP.h"

#ifndef MAX_LEN
#define MAX_LEN 8
#endif

/**
* Counter example
*
* @code
* #include "mbed.h"
* #include "Counter.h"
* 
* int main(void) {
*     
*     Counter ct;
*     while (true) {
*         ct.increment(rand()%MAX_LEN);
*         wait(0.5);
*     }
* }
* @endcode
*/

class Counter
{
public:
    int count[MAX_LEN];
    int is_new_count;
    int address;
    /** Initialize count array
    *
    *   Either initializes count array to zeroes or existing count
    *   depending on whether it has been called before or not
    *
    */
    void init(void);
    /** Decrement count
    *
    *   Simply decrement value of index
    *   Private to disallow access for this specific purpose;
    *   @param index Index of count array to be decremented
    *
    */
    void decrement(int index);
    
//public:

    /** Default Constructor
    *
    *   Sets read/write memory addresss of Flash memory
    *   Also calls init()
    *
    */
    Counter();
    
    /** Write to Memory
    *
    *   Writes current count array to Flash Memory
    *
    */
    void memwrite(void);
    
    /** Read from memory
    *
    *   Loads values of existiing count array from Flash Memory
    *
    */
    void memread(void);
    
    /** Increment count
    *
    *   Simply increments value of index
    *
    *   @param index Index of count array to be incremented
    *
    */
    void increment(int index);
    /** Clears Count
    *
    * RESETS count array
    *
    */
    void clear();
    
    /** Simple print function
    *
    *   Prints all memory addresses in count array with values for debugging purposes.
    *
    */
    void print_memory(void);

};

#endif