#include "Counter.h"
#include "mbed.h"

//#define COUNTER_DEBUG


Serial debug_out(USBTX, USBRX);

Counter::Counter()
{
    is_new_count = flash_size() - SECTOR_SIZE;
    address = (int)((int*)(flash_size() - SECTOR_SIZE) + 1);
#ifdef COUNTER_DEBUG
    debug_out.printf("Constructing Object...\r\n");
#endif
    memset(&count, 0, MAX_LEN);
    this->init();
}


void Counter::print_memory()
{
    int *ptr = (int*) address;
    printf("PartyID\tVoteCt\tMemCt\tAddress\r\n");
    for(int i=0; i<MAX_LEN; i++) {
        printf("%dID\t%d\t%d\t%p\r\n", i, count[i], ptr[i], (ptr+i));
    }
}

void Counter::init()
{
#ifdef COUNTER_DEBUG
    debug_out.printf("Initializing...\r\n");
#endif
    if(*((int*)is_new_count) == -1) { // then we know it hasn't been initialized yet
        erase_sector(is_new_count);
        int zero = 0;
        program_flash(is_new_count, (char*)&zero, sizeof(int));
        memwrite();
    } else {
        memread();
    }
#ifdef COUNTER_DEBUG
    print_memory();
#endif
}

void Counter::memwrite()
{
#ifdef COUNTER_DEBUG
    debug_out.printf("Writing to Flash\r\n");
#endif
    erase_sector(address);
    int zero = 0;
    program_flash(is_new_count, (char*)&zero, sizeof(int));
    program_flash(address, (char*)&count, sizeof(int) * MAX_LEN);
#ifdef COUNTER_DEBUG
    print_memory();
#endif
}

void Counter::memread()
{
#ifdef COUNTER_DEBUG
    debug_out.printf("Reading from Flash\r\n");
#endif
    for(int i=0; i<MAX_LEN; i++) {
        count[i] = *((int*)address+i);
    }
}

void Counter::increment(int party_id)
{
#ifdef COUNTER_DEBUG
    debug_out.printf("Incrementing %d\r\n", party_id);
#endif
    count[party_id]++;
    memwrite();
}

void Counter::decrement(int party_id)
{
#ifdef COUNTER_DEBUG
    debug_out.printf("Decrementing %d\r\n", party_id);
#endif
    count[party_id]--;
    memwrite();
}

void Counter::clear(){
    #ifdef COUNTER_DEBUG
        debug_out.printf("Clearing stored values\r\n");
    #endif
    memset(&count, 0, MAX_LEN);
}