#include "IMU.h"
#include "PID.h"
#include "Motor.h"
#include "HMC5883L.h"

// Maps value from incoming analog signal to correct range
// to be sent out to as pwm signal to motors
float map(float x, float in_min, float in_max, float out_min, float out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


DigitalOut  my_led(LED1);

// Individual pid parameters
double myYaw, yawPoint, yawOut;
double myPitch, pitchPoint, pitchOut;
double myRoll, rollPoint, rollOut;
double myDepth, depthPoint, depthOut;

//Declare digital button input                  tuning parameters   //FIXME
DigitalIn tuningButton(USER_BUTTON);            

// Declare mpu6050 and compass object
MPU6050 mpu1;
HMC5883L compass;

// Declare analog input pin ( kp, ki, kd )      tuning parameters
AnalogIn    tuneKnob(A0);

// Declare motor pins
PwmOut      m1(D3);
PwmOut      m2(D4);
PwmOut      m3(D5);
PwmOut      m4(D6);

// PWM output variable for each motor
int m1pwm, m2pwm, m3pwm, m4pwm;

// Input, Output, SetPoint, kp, ki, kd, Controller Direction
PID pidy(&myYaw, &yawOut, &yawPoint, 1, 1, 1, DIRECT);
PID pidp(&myPitch, &pitchOut, &pitchPoint, 1, 1, 1, DIRECT);
PID pidr(&myRoll, &rollOut, &rollPoint, 1, 1, 1, DIRECT);
PID pidd(&myDepth, &depthOut, &depthPoint, 1, 1, 1, DIRECT);

//Serial pc(USBTX, USBRX);

// Serial communication between Arduino NANO
RawSerial device(PA_11, PA_12);  //TX RX

Timer calibrate;

int depth = 1;

int main()
{   
    // Initialize IMU
    IMUinit(mpu1);
    
    // Initialize Magnetometer
    compass.init();
    
    // Initialize PID's 
    pidy.SetMode(AUTOMATIC);            // Yaw PID
    pidy.SetOutputLimits(1500, 1700);
    
    pidp.SetMode(AUTOMATIC);            // Pitch PID
    pidp.SetOutputLimits(1500, 1700); 
    
    pidr.SetMode(AUTOMATIC);            // Roll PID
    pidr.SetOutputLimits(1500, 1700);
    
    pidd.SetMode(AUTOMATIC);            // Depth PID
    pidd.SetOutputLimits(1500, 1700); 

    
    // Default kp ki kd parameters
    float kpKnobVal = .028;
    float kiKnobVal = .01;
    float kdKnobVal = .025;
    
    // Configure PID's
    pidd.SetTunings(kpKnobVal, kiKnobVal, kdKnobVal);
    depthPoint = 0;
    
    //Calibrate IMU
    calibrate.start();
    while(calibrate.read() < 5);
    {
        IMUPrintData(mpu1, compass);
        my_led = 1;
    }
    my_led = 0;
    
    calibrate.stop();

    while(1)
    {    
        //-------------------------SENSE--------------------------------
    
        // Read pressure sensor data if available
        if (device.readable())
        {
            // Receive depth in inches as an integer
            depth = device.getc();
            
            // Convert to feet
            
            // Display received data
           // pc.printf("%d \n", pressure);
        }
        
        // Obtain mpu data -> pass through filter -> obtain yaw pitch roll
        IMUPrintData(mpu1, compass);
        
        // Assign feedback variables
        myDepth = depth;
        
        //------------------------End SENSE----------------------------
        
        
        //------------------------Tuning ADJUST-------------------------    FIXMEEEEEE
        
        // If button is pressed kp ki kd values can be adjusted
        if(!tuningButton)
        {
            // Read raw potentiometer values from k-knob and map to kpknobVal
            kpKnobVal = map(tuneKnob.read(), 0.000, 1.000, 0.000, .050);
           
            
            // Adjust tunings
            pidp.SetTunings(kpKnobVal,kiKnobVal,kdKnobVal);
            
        }
        //print mapped joystick values
       // pc.printf("kp: %f -- ki: %f -- kd %f \n", kpKnobVal, kiKnobVal, kdKnobVal);  
        
        //------------------------End tuning ADJUST-----------------------
        
        
        //------------------------Motor Control LOOP----------------------
        
        // Compute output using pid controller
        pidd.Compute();
        
        // Assign pid output pwm to individual pwm variables
        m1pwm = depthOut;
        m2pwm = depthOut;
        m3pwm = depthOut;
        m4pwm = depthOut;
        
        // Output pwm
        m1.pulsewidth_us(m1pwm);
        m2.pulsewidth_us(m2pwm);
        m3.pulsewidth_us(m3pwm);
        m4.pulsewidth_us(m4pwm);
        
        //------------------------End Motor Control LOOP-------------------    
        
        
        //------------------------Display TELEMETRY------------------------
        char text[90];
        sprintf(text, "%f,%f,%f,%d \n", yaw, pitch, roll, depth);
        pc.printf("%s", text);
        //--------------------------End TELEMETRY--------------------------
        
    }
}
 
