#include "mbed.h"
#include "Mx28.h"


#define SERVO_ID 0x01               // ID of which we will set Dynamixel too 
#define SERVO_ControlPin D11       // Control pin of buffer chip, NOTE: this does not matter becasue we are not using a half to full contorl buffer.
#define SERVO_SET_Baudrate 115200  // Baud rate speed which the Dynamixel will be set too (1Mbps)
#define TxPin D10
#define RxPin D2
#define CW_LIMIT_ANGLE 0x001        // lowest clockwise angle is 1, as when set to 0 it set servo to wheel mode
#define CCW_LIMIT_ANGLE 0xFFF       // Highest anit-clockwise angle is 0XFFF, as when set to 0 it set servo to wheel mode

DynamixelClass dynamixelClass(SERVO_SET_Baudrate,SERVO_ControlPin,TxPin,RxPin);

int main() 
{
    dynamixelClass.setMode(SERVO_ID, SERVO, CW_LIMIT_ANGLE, CCW_LIMIT_ANGLE);    // set mode to SERVO and set angle limits
          
    while(1)
    {
        dynamixelClass.ledState(SERVO_ID, ON);
        dynamixelClass.servo(SERVO_ID,0x001,0x040);   // Move servo to angle 1(0.088 degree) at speed 100
        wait(8);
        
        dynamixelClass.ledState(SERVO_ID, OFF);
        dynamixelClass.servo(SERVO_ID,0xFFF,0x3FF);  //  Move servo to max angle at max speed
        wait(5);               
    }  
}
