#include "mbed.h"

DigitalIn botao(PC_13);//botão do usuário
AnalogIn potenciometro(PB_1);//entrada do potenciômetro
Serial pc(USBTX, USBRX);//porta serial
PwmOut IN_1 (PA_8); // pinos placa IHM07M1 - Usa para PWM
PwmOut IN_2 (PA_9);
PwmOut IN_3 (PA_10);
DigitalOut EN_1 (PC_10); // pinos placa IHM07M1 ENABLE
DigitalOut EN_2 (PC_11);
DigitalOut EN_3 (PC_12);

int valor_potenciometro; //salvando o valor lido no potenciômetro numa variável
float intervalo;
bool ativado;

int main()
{
    ativado=false;
    pc.baud(9600);
    //configurações iniciais
    EN_1 = 2; // Braço 1 (A)
    EN_2 = 2; // Braço 2 (B)
    EN_3 = 2; // Braço 3 (C)
    IN_1.period_ms(1); // PWM = 1 ms
    IN_2.period_ms(1); // PWM = 1 ms
    IN_3.period_ms(1); // PWM = 1 ms
    IN_1.write(0); // PWM com valor 0%
    IN_2.write(0); // PWM com valor 0%
    IN_3.write(0); // PWM com valor 0%
    
        
    while(1)
    {
         valor_potenciometro= potenciometro.read_u16();
         intervalo= valor_potenciometro*(0.01-0.005)/(65535)+0.005;//regra de três para manter valor entre 0.01 e 0.005
        
         if (botao==0)//quando alterar o estado da variável de liga-desliga
         {
             ativado=!ativado;
             wait(0.3);
        }
         if(ativado)
         {
            //step1
            IN_1 =1;
            EN_1 = 1;
            wait(intervalo);
            IN_1=0;
            EN_1 = 2;

            //step2
            IN_3=1;
            EN_3 = 0;
            wait(intervalo);
            IN_3=0;
            EN_3 = 2;

            //step3
            IN_2=1;
            EN_2 = 1;
            wait(intervalo);
            IN_2=0;
            EN_2 = 2;

            //step4
            IN_1=1;
            EN_1 = 0;
            wait(intervalo);
            IN_1=0;
            EN_1 = 2;

            //step5
            IN_3=1;
            EN_3 = 1;
            wait(intervalo);
            IN_3=0;
            EN_3 = 2;

            //step6
            IN_2=1;
            EN_2 = 0;
            wait(intervalo);
            IN_2=0;
            EN_2 = 2;
         }
    }
}             
             
             
         



    