#include "mbed.h"
// Definição das entradas utilizadas
DigitalOut IN1A (D5);
DigitalOut IN2A (D4);
PwmOut ENA (D2);
Serial pc(USBTX, USBRX);
AnalogIn potenciometro(A5);
InterruptIn sinal_encoder(D7);

//Definição das variáveis referentes ao cronômetro, contador e RPM
Timer cronometro;
int repeticoes;
int rpm;

// Criação de uma função para incrementar o valor do contador
void registro_encoder(void){
    repeticoes++;
}


int main(){
    cronometro.start();// começa cronometragem
    sinal_encoder.fall(&registro_encoder);// soma 1 à contagem se detectada uma borda de descida do sinal do encoder
    float valor_pot; // valor recebido do potenciômetro
    pc.baud(9600);// taxa de transferência de informações da serial
    while(1){
        // Envia para o motor tensão proporcional ao valor do potenciômetro
        valor_pot=potenciometro.read();
        ENA.write(valor_pot);
        IN1A=0;
        IN2A=1;
        if(repeticoes>=120){ // Calcula o rpm quando as repetições igualarem 120 (4 revs)
            rpm= (4/(cronometro/60));
            pc.printf("omega(rpm):%d\n\r",rpm);// Printa o valor de duty cycle e rpm
            pc.printf("\rdtc=%1.2f",valor_pot);
            repeticoes=0; // reseta a contagem do encoder e do cronômetro
            cronometro.reset();
            }
        }
    }
        
    