/*'Frisensor' code for a game that generates a sequence of leds (4), and checks if the user
is able to remember the sequence and reproduce it with ultrasonic sensor
Designed for the subject "informatica industrial", 
in Tecnologico de Monterrey Campus Guadalajara
as of May 11 2014
v 1.1*/
/* Authors: Jorge Muñoz, Ismael Davila, Miguel Ortiz, Carlos Reyes
*/

#include "mbed.h"
#include "TextLCD.h"
#include "Timer.h"
#include "PinDetect.h"
/*copyright of pindetect library
Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
*/

//LCD
TextLCD lcd( D2, D3, D4, D5,D6, D7, TextLCD::LCD16x2);
//leds
BusOut leds(PTC3, PTC4, PTC5, PTC6);
// Sensores
AnalogIn sensor_1(A0);
AnalogIn sensor_2(A2);
AnalogIn sensor_3(A4);
AnalogIn sensor_4(A1);
//pot for velocity of leds
AnalogIn pot(A3);
//variables fot sensors
float s1,s2,s3,s4;
//modes----------
int modo_lectura=0;
int gamemode=0;
int start_mode=0;
//array for points
int points_array[10];
int points_pointer=0;

//array for levels
int level_array[20];//max 19 levels
int level_selection=1;
//timer
Timer timer;

//
int contador;
int i;//its used for some "fors"
int show_time=500;
int scores_time=0;

// Button with antibouncing effect------
PinDetect start_button(PTA13);
/*PinDetect levelup(PTD5);
PinDetect leveldown(PTD0);*/
PinDetect show_scores(PTD2);

//functions-----------------------------
void leds_function(int *ptr_randomvalue, int *ptr_busoutvalue);//function that displays the sequence of leds
int tiempo_apagado, leds_value;
void secuence_generator(int *ptr_level);//function that generates the sequence of the level

//functions fot buttons----------------
void start_reset();
void levelupfunction();
void leveldownfunction();
void show_scores_function();
int main()
{

    contador=0;
    secuence_generator(&level_selection);
    timer.start();
    //because we are using internal PullUp resistors we use deasserted
    start_button.attach_deasserted(&start_reset);
    /*leveldown.attach_deasserted(&levelupfunction);
    levelup.attach_deasserted(&leveldownfunction);*/
    show_scores.attach_deasserted(&show_scores_function);
    //because we are using internal PullUp resistors we need to add this
    start_button.mode(PullUp);
    /*leveldown.mode(PullUp);
    levelup.mode(PullUp);*/
    show_scores.mode(PullUp);
    start_button.setSampleFrequency();
    show_scores.setSampleFrequency();
    while(1) {
        while(start_mode==0) {//mode Press Start---------------------------
            if((timer.read_ms()>show_time+500) && (timer.read_ms()>scores_time+4000)) {
                lcd.cls();
                contador=0;
                timer.reset();
                lcd.printf("press start \nnivel %i \n", level_selection);
                secuence_generator(&level_selection);
            }
        }
        while((gamemode==0)&&(start_mode==1)) {//mode show led sequence----------------------
            while(timer.read_ms()>(pot.read()*1000)+200) {
                leds_function(&level_array[contador],&leds_value);
                leds=leds_value;
                contador++;
                timer.reset();
                tiempo_apagado=((pot.read()*1000)+200)/2;
            }
            while(timer.read_ms()>tiempo_apagado) {
                tiempo_apagado=tiempo_apagado+(pot.read()*1000)+200;
                leds=0;
                if(contador==(level_selection+1)) {
                    gamemode=1;
                    leds=0;
                    contador=0;
                    lcd.cls();
                }
            }
        }
        while((gamemode==1)&&(start_mode==1)) {//gaming mode-------------------------------
            while(modo_lectura==0) {
                s1=sensor_1.read();
                s2=sensor_2.read();
                s3=sensor_3.read();
                s4=sensor_4.read();
                if((s1>0.05)&&(s2>0.05)&&(s3>0.05)&&(s4>0.05)) {// verify that there is nothing above leds
                    modo_lectura=1;
                    lcd.printf("Empieza!!\n");
                }
            }
            while(modo_lectura==1) {
                s1=sensor_1.read();
                s2=sensor_2.read();
                s3=sensor_3.read();
                s4=sensor_4.read();
                if(contador!=0) {
                    lcd.cls();
                }
                if(s1<0.017 && level_array[contador]==1) {// sensor 1 code----------------
                    modo_lectura=0;
                    contador++;
                    lcd.printf("good \n");
                } else if(s1<0.017 && level_array[contador]!=1) {
                    lcd.printf("Perdiste \n");
                    show_time=timer.read_ms();
                    if(points_pointer==9) {
                        for (i=0; i<9; i++) {
                            points_array[i]=points_array[i+1];
                        }
                    } else {
                        points_pointer++;
                    }
                    modo_lectura=0;
                    gamemode=0;
                    contador=0;
                    start_mode=0;
                    level_selection=1;
                }
                if(s2<0.017 && level_array[contador]==2) {// sensor 2 code-----------------------
                    modo_lectura=0;
                    contador++;
                    lcd.printf("good \n");
                } else if(s2<0.017 && level_array[contador]!=2) {
                    lcd.printf("perdiste \n");
                    show_time=timer.read_ms();
                    if(points_pointer==9) {
                        for (i=0; i<9; i++) {
                            points_array[i]=points_array[i+1];
                        }
                    } else {
                        points_pointer++;
                    }
                    modo_lectura=0;
                    gamemode=0;
                    contador=0;
                    start_mode=0;
                    level_selection=1;
                }
                if(s3<0.017 && level_array[contador]==3) {// sensor 3 code------------------------
                    modo_lectura=0;
                    contador++;
                    lcd.printf("good \n");
                } else if(s3<0.017 && level_array[contador]!=3) {
                    lcd.printf("Perdiste \n");
                    show_time=timer.read_ms();
                    if(points_pointer==9) {
                        for (i=0; i<9; i++) {
                            points_array[i]=points_array[i+1];
                        }
                    } else {
                        points_pointer++;
                    }
                    start_mode=0;
                    modo_lectura=0;
                    gamemode=0;
                    contador=0;
                    level_selection=1;
                }
                if(s4<0.017 && level_array[contador]==4) {// sensor 4 code-------------------------
                    modo_lectura=0;
                    contador++;
                    lcd.printf("good \n");
                } else if(s4<0.017 && level_array[contador]!=4) {
                    lcd.printf("Perdiste \n");
                    show_time=timer.read_ms();
                    if(points_pointer==7) {
                        for (i=0; i<7; i++) {
                            points_array[i]=points_array[i+1];
                        }
                    } else {
                        points_pointer++;
                    }
                    modo_lectura=0;
                    gamemode=0;
                    contador=0;
                    start_mode=0;
                    level_selection=1;
                }
            }
            if(contador>level_selection) {//check if theres winners-------------------
                lcd.printf("ganaste \n");
                gamemode=0;
                points_array[points_pointer]=points_array[points_pointer] + level_selection*2;
                lcd.printf("puntos %i",points_array[points_pointer] );
                wait(3);//just to keep the word "ganaste" in the display for some time
                level_selection++;
                secuence_generator(&level_selection);
                contador=0;
            }
        }
    }//end_of_while(1)
}//end_of_int_main
//functions
//function to generate sequences-------------------------
void secuence_generator(int *ptr_level)
{
    int j;

    srand (time(NULL));
    for (j=0; j<=(*ptr_level); j++) {
        level_array[j]=rand()%4+1;
    }
}
//function to show the number in leds-------------------
void leds_function(int *ptr_randomvalue, int *ptr_busoutvalue)
{
    switch(*ptr_randomvalue) {
        case 0:
            *ptr_busoutvalue=0;
            break;
        case 1:
            *ptr_busoutvalue=1;
            break;
        case 2:
            *ptr_busoutvalue=2;
            break;
        case 3:
            *ptr_busoutvalue=4;
            break;
        case 4:
            *ptr_busoutvalue=8;
            break;
    }
}
void levelupfunction()
{
    level_selection++;
    start_mode=0;
}
void leveldownfunction()
{
    level_selection--;
    start_mode=0;
}
void start_reset()
{
    start_mode=!start_mode;
    contador=0;
}
void show_scores_function()
{
    lcd.cls();
    for (i=0; i<8; i++) {
        lcd.printf("%i:%i,", i+1,points_array[i]);
        scores_time=timer.read_ms();
    }
    start_mode=0;
}