#include "mbed.h"
#include "EthernetInterface.h"

InterruptIn BTN_send(p14);
DigitalOut led(LED1);
DigitalOut led_rx(LED2);

RawSerial device(p9, p10);  // tx, rx

volatile int flagB = 0;
volatile int flagS = 0;

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 16;
// might need to increase buffer size for high baud rates
char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
volatile int rx_in=0;

EthernetInterface eth;
TCPSocketConnection sock;

void BTN_send_TCP()
{
    led = !led;
    flagB = 200;
}

void UART_send_TCP()
{
    int byte_counter = 0;
    
    led_rx = 1;
    while (device.readable() and (byte_counter != 5))
    {
        rx_buffer[rx_in] = device.getc();
        rx_in = (rx_in + 1) % buffer_size;
        
        byte_counter++;
    }
    flagS = 200;
    led_rx = 0;
}

int main() 
{
    BTN_send.rise(&BTN_send_TCP);
    device.baud(9600);
    device.attach(&UART_send_TCP, Serial::RxIrq); 
    
    //device.printf("teste UART 2\n\r");  
    
    //EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    //TCPSocketConnection sock;
    sock.connect("10.0.126.202", 8888);
    //sock.connect("192.168.1.7", 8888);
    
    char cmd[] = "teste ethernet MBED e C#! Visual Studio Rules!!!\n\r";
    char cmd2[] = "another test by button fuction flag\n\r";
    sock.send_all(cmd, sizeof(cmd)-1);
    
    while (true)
    {
        if(flagB == 200)
        {
            flagB = 0;
            sock.send_all(cmd2, sizeof(cmd2)-1);
        }  
        if(flagS == 200)
        {
            flagS = 0;
            sock.send_all(rx_buffer, 5);
            //sock.send_all(rx_buffer, sizeof(rx_buffer)-1);
            rx_in = 0;
        }  
    }   
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}
