#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "JPEGCamera.h"
//#include "rtos.h"


EthernetNetIf eth(
    IpAddr(192,168,1,10), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,1), //Gateway
    IpAddr(192,168,1,1)  
);
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");    // (signalPin was replaced with led2 as led2 was not being used)
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut pin11(p11);      // pin for resetting
DigitalOut pin12(p12);      // pin for showing error with camera while taking reference image led4 is also used
DigitalOut pin13(p13);      // pin for showing error with camera while taking new image
     
DigitalOut pin3(p23);     // motor pin from analogVal of sensor 
DigitalOut pin30(p30);     // buzzer  
DigitalOut signalPin(p25);

Serial pc(USBTX,USBRX);
Serial xbee(p28, p27);    // TX, RX for Xbee
JPEGCamera camera(p9, p10); // TX, RX for Camera
LocalFileSystem fs("webfs");
char discard=NULL;

void callback(void)
{  
            if(xbee.getc()==0x7E)
{               discard = xbee.getc();
                char leng=xbee.getc();
                for(int i=1;i<=16;i++) discard = xbee.getc();
                int high = xbee.getc();
                int low=xbee.getc();
                if(leng==0x12)
{
                int analogVal = high*256 + low;
                pc.printf("High=%d Low=%d AnalogValue= %d\r\n",high,low,analogVal);
                char discard= xbee.getc();
                /*
                if(analogVal<600 && pin3==1)
                {
                 char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x33,0x04,0x24};   //FOR SETTING PIN D3 low   
                 for(int i=0;i<20;i++) xbee.putc(buff[i]);
                 pin3=0;     //  p25
                 wait(0.1);
                 while(xbee.readable()) char discard=xbee.getc();
                }
              if(analogVal>600 && pin3==0)
                {
                 char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x33,0x05,0x23};   //FOR SETTING PIN D3 HIGH
                 for(int i=0;i<20;i++) xbee.putc(buff[i]);
                 pin3=1;     //  p25
                 wait(0.1);
                 while(xbee.readable()) char discard=xbee.getc();
                }   */   
}  
}          
}

//Create a function of the required format
//void rpcMOTOR(char * input, char * output);
void rpcX10rf(char * input, char * output);
//RPCFunction rpc_foo2(&rpcMOTOR, "rpcMOTOR");
RPCFunction rpc_foo(&rpcX10rf, "rpcX10rf");
void rpcX10rf(char * input, char * output) 
{
            char houseCode;
            short int numberCode, action;
            pc.printf("%s\r\n", input);
            sscanf(input, "  %c,%d,%d", &houseCode, &numberCode, &action);
            pc.printf("%c, %d,%d\r\n", houseCode, numberCode, action);
                 if(numberCode==4 && action==1){led1=1;}    // 5 replaced 4
            else if(numberCode==4 && action==0){led1=0;}    // 5 replaced 4
            else if(numberCode==2 && action==1){led2=1;}
            else if(numberCode==2 && action==0){led2=0;}
            else if(numberCode==5 && action==1)                 // // 4 replaced 5
            {
                      
                char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x33,0x05,0x23};   //FOR SETTING PIN D3 HIGH
                 for(int i=0;i<20;i++) xbee.putc(buff[i]);
                 led4=1;     //  p25
                 wait(0.1);
                 while(xbee.readable()) char discard=xbee.getc();
                      
                 }
            else if(numberCode==5 && action==0)                 // // 4 replaced 5
            {
                  
                char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x33,0x04,0x24};   //FOR SETTING PIN D3 low   
                for(int i=0;i<20;i++) xbee.putc(buff[i]);
                led4=0;     //  p25
                wait(0.1);
                while(xbee.readable()) char discard=xbee.getc();
                  
                }
            
   
  
}


void takeImgRef(void);
void takeNewImage(float x);
void doreset(void);
int Count;
int devicesAction(int Count);
       
int main() 
{
      Count=0;
      Timer tm;
      pc.baud(9600);
    xbee.baud(9600);
       
    led2=0;    // signalPin was here
    signalPin=0;    ///  changed here
    Base::add_rpc_class<DigitalOut>();
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        pc.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    pc.printf("\r\nSetup OK\r\n");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    //svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
    svr.bind(80);
    
    printf("Server Start and Setting Camera\r\n");
    
   // camera.reset();
  //  pc.printf("Setting SIZE 320X240");
    camera.setPictureSize(JPEGCamera::SIZE320x240);
  //  pc.printf("\nSetting SIZE 320X240 done and Taking reference image\n");
     pin12=1;
     takeImgRef();
  //  xbee.attach(&callback);
    tm.start();
  //  wt.start();
     while(pc.readable()==0)
{       Net::poll();
        if (tm.read()>.5) 
         { //led1=!led1; //Show that we are alive
          tm.reset();
         }
      takeNewImage(tm.read());
      
   //   if(pin11==1) doreset();
   //   if(pin12==1) takeImgRef();

      if(xbee.readable()) callback();
      
      if (led1==1 && Count==0)   // 
      {    pc.printf("Making High");
           char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x32,0x05,0x24};  //FOR SETTING PIN D2 HIGH    
           
           for(int i=0;i<=19;i++) xbee.putc(buff[i]);
           
           wait(0.1);
           while(xbee.readable()) {char discard=xbee.getc();Count=1; }
    
       }
      if (led1==0 && Count==1)  //  && Count==1
       {    pc.printf("Making low");  
           
           char buff[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0xB5,0x92,0x0D,0xFF,0xFE,0x02,0x44,0x32,0x04,0x25};  //FOR SETTING PIN D2 LOW
           for(int i=0;i<=19;i++) xbee.putc(buff[i]);
           wait(0.1);
           while(xbee.readable()){ char discard=xbee.getc();Count=0;}
       }    
}
}

void takeNewImage(float x)
{   if(signalPin==0 && led2==0)      //  change was here for led2
    {
    remove("/webfs/PICT.jpg");   
        pc.printf("Capturing new image Picture\r\n");
     // camera.reset();
      if (camera.isReady()) 
       {    char filename[32];
            sprintf(filename, "/webfs/PICT.jpg");
            pc.printf("Picture: %s \r\n", filename);
            if (camera.takePicture(filename)) 
            { while (camera.isProcessing()) camera.processPicture();
            led4=0; 
          //  led2=1; //change was here
            signalPin=1;
            
            } else {pc.printf("take picture failed\n"); led4=1; camera.reset();} // pin13=1;}
       }else {pc.printf("camera is not ready\n");led4=1; camera.reset();} // pin13=1;}
      
      
      pc.printf("Took PICT\r\n");
    } else {   pc.printf("waiting for processing \r\n");
            if (x > .2) {led3=!led3;} //Show that waiting for response
            
            }
}



void doreset(void)
{
   camera.reset();
    if(!(camera.isReady()))
    doreset();
    pin11=0;
}



void takeImgRef(void)
{
  //camera.reset();
      if (camera.isReady()) 
    {
            char filename[32];
            sprintf(filename, "/webfs/IMG_REF.jpg");
            pc.printf("Picture: %s \r\n", filename);
            if (camera.takePicture(filename)) 
            {while (camera.isProcessing()) camera.processPicture();
             pin12=0;
             led4=0;  
            } else {pc.printf("take picture failed\n"); led4=1; camera.reset();}
    } else {pc.printf("camera is not ready\n"); led4=1; camera.reset();}
               
    pc.printf("Took IMG_REF \r\n");
  
}
