
/* Program Example: 12.4 mbed file server setup
                                                           */
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "FsHandler.h"

EthernetInterface eth;            // define Ethernet interface
LocalFileSystem fs("webfs");      // define Local file system
HTTPServer svr;                   // define HHTP server object

int main() {
  eth.init("192.168.1.101","255.255.255.0","192.168.1.1");   // initialise Ethernet
  eth.connect();                               // connect Ethernet
  HTTPFsRequestHandler::mount("/webfs/", "/"); // mount file server handler
  svr.addHandler<HTTPFsRequestHandler>("/");   // add handler to server object
  svr.start(80, &eth);                    // bind server to port 80
  while(1)
  {
    svr.poll();          // continuously poll for Ethernet messages to server
  }
}

// address to locate HOME.HTM
// http://192.168.1.101/HOME.HTM 