/* Program Example 14.6: Explore ADC conversion times, programming control registers directly. ADC value is transferred to DAC, while an output pin is strobed to indicate conversion duration. Observe on oscilloscope
                                                                            */
//….
//….

int main() {
  FIO2DIR0=0xFF;                      // set lower bits port 2 to output
  PINSEL1=0x00210000;  //set bits 21-20 to 10 for analog output (mbed p18) 
         //and bits 17-16 to 01 to enable ADC channel 1 (AD0.1, mbed pin 16)

//initialise the ADC. 
//….
//….
  while(1){         // infinite loop
    // start A/D conversion by modifying bits in the AD0CR register 
    AD0CR &= (AD0CR & 0xFFFFFF00);  
    FIO2PIN0 |= 0x01;               // OR bit 0 with 1 to set pin high
    AD0CR |= (1 << ADC_channel) | (1 << 24);       
    // wait for it to finish by polling the ADC DONE bit         
    while((AD0GDR & 0x80000000) == 0) {
    }
    FIO2PIN0 &= ~0x01;             // AND bit 0 with 0 to set pin low

    ADCdata = AD0GDR;              // get the data from AD0GDR
    AD0CR &= 0xF8FFFFFF;           //stop ADC by setting START bits to zero
        
   // shift data 4 bits to right justify, and 2 more to give 10-bit ADC value
    ADCdata=(ADCdata>>6)&0x03FF;   //and mask      
    DACR=(ADCdata<<6);     //could be merged with previous line,
                              // but separated for clarity
    //delay();               //insert delay if wished
  }
}

