/* Program Example 13.5: CAN data read – reads CAN messages from the CAN bus                    
                                                                            */
#include "mbed.h"
Serial pc(USBTX, USBRX);          // tx, rx for Tera Term output
DigitalOut led2(LED2);            // status LED
CAN can1(p9, p10);                // CAN interface
int main() {
  CANMessage msg;                 // create empty CAN message
  printf("read...\n");
  while(1) {
    if(can1.read(msg)) {          // if message is available, read into msg
      printf("Message received: %d\n", msg.data[0]);   // display message data
      led2 = !led2;                                    // toggle status LED
    } 
  }
}

