/* Program Example 13.4: CAN data write – sends an incrementing count value to the CAN bus every second.
                                                                            */
#include "mbed.h"
Serial pc(USBTX, USBRX);          // tx, rx for Tera Term output

DigitalOut led1(LED1);            // status LED
CAN can1(p30, p29);               // CAN interface
char counter = 0;
int main() {
  printf("send... ");
  while (1) {       
    // send value to CAN bus and monitor return value to check if CAN
    // message was sent successfully. If so display, increment and toggle
    if (can1.write(CANMessage(1, &counter, 1))) {  
       pc.printf("Message sent: %d\n", counter);       // display
       counter++;                                   // increment
       led1 = !led1;                                // toggle status LED
    }else{
      can1.reset();
    }
    wait(1);
  }
}
