/* Program Example 13.1: HMC6352 Compass Setup and Read
                                                            */
#include "mbed.h"
// mbed objects
I2C compass(p28, p27);            // sda, scl
Serial pc(USBTX, USBRX);          // tx, rx
// variables
const int addr = 0x42;            // define the I2C write Address
char cmd[3];                      // command array for read and write
float pos;                        // measured position

// main code
int main() {
  cmd[0] = 0x47;                // 'G' write to RAM address
  cmd[1] = 0x74;                // Operation mode register address
  cmd[2] = 0x72;                // Op mode = 20H, no S/R, continuous 
  compass.write(addr,cmd, 3);   // Send operation
  while (1) {
    compass.read(addr, cmd, 2);   // read the two-byte echo result
    pos = 0.1 * ((cmd[0] << 8) + cmd[1]);   //convert to degrees
    if (pos>180){
       pos=pos-360;
    }
    pc.printf("deg = %.1f\n", pos);
    wait(0.3);                    
  }
}

