/* Program Example 12.12 Using RPC variables for remote mbed control
                                                                        */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCVariable.h"
#include "SerialRPCInterface.h"
LocalFileSystem fs("webfs");
EthernetNetIf eth(
    IpAddr(192,168,0,101),//IP Address
    IpAddr(255,255,255,0),//Network Mask
    IpAddr(192,168,0,1),  //Gateway
    IpAddr(192,168,0,1)   //DNS
);
HTTPServer svr;
DigitalOut Led1(LED1);              // define mbed object
DigitalIn Button1(p21);             // button
int RemoteLEDStatus=0;
RPCVariable<int> RPC_RemoteLEDStatus(&RemoteLEDStatus,"RemoteLEDStatus");
int RemoteLED1Button=0;
RPCVariable<int> RPC_RemoteLED1Button(&RemoteLED1Button,"RemoteLED1Button");
int main() {
    Base::add_rpc_class<DigitalOut>();        // RPC base command
    eth.setup();                              // Ethernet setup
    FSHandler::mount("/webfs", "/");   // Mount /webfs path root path
    svr.addHandler<FSHandler>("/"); //Default handler
    svr.addHandler<RPCHandler>("/rpc");       // Define RPC handler
    svr.bind(80);
    printf("Listening...\n");
    while (true) {
        Net::poll();
        if ((Button1==1)|(RemoteLED1Button==1)) {
            Led1=1;
            RemoteLEDStatus=1;
        } else {
            Led1=0;
            RemoteLEDStatus=0;
        }
    }
}

