/* Program Example: 12.10 mbed file server setup
                                                           */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
LocalFileSystem fs("webfs");
EthernetNetIf eth(
  IpAddr(192,168,0,101),      //IP Address
  IpAddr(255,255,255,0),      //Network Mask
  IpAddr(192,168,0,1),        //Gateway
  IpAddr(192,168,0,1)         //DNS
);
HTTPServer svr;
int main() {
  eth.setup();
  FSHandler::mount("/webfs", "/");    //Mount webfs path on root path
  svr.addHandler<FSHandler>("/");     //Default handler
  svr.bind(80);
  while(1)
  {
    Net::poll();                  // poll for internet data exchange requests
  }
}

