/* Program Example 12.6: MIDI messaging with variable scroll speed
                                                                   */
#include "mbed.h"
#include "USBMIDI.h”
USBMIDI midi;                        // initialise MIDI interface
AnalogIn Ain(p19);                   // create analog input

int main() {             
    while (1) {    
        for(int i=48; i<72; i++) {                 // step through notes
            midi.write(MIDIMessage::NoteOn(i));    // note on
            wait(Ain);                             // pause
            midi.write(MIDIMessage::NoteOff(i));   // note off  
            wait(2*Ain);                           // pause
        }
    }
}

