/* Program Example 12.4: Paired Bluetooth master program
                                                            */
#include "mbed.h"
Serial rn41(p9,p10);
BusOut led(LED4,LED3,LED2,LED1);
DigitalIn Din(p26);                // digital switch input on pin 14

char x;
void initialise_connection(void);

int main() {
  rn41.baud(115200);
  initialise_connection();
  while (1) {
    if (Din==1) {            // if digital input switched high   
      x=0x0F;              // override with 0x0F
    } else {
      x++;                 // else increment and
      if (x>0x0F) {        // output count value
        x=0;
      }
    }
    rn41.putc(x);            // send char data on serial
    led = x;                 // set LEDs to count in binary
    wait(0.5);
  }
}

// add function initialise_connection code here...

