/* Program Example 11.5: 16-bit mono wave player
                                                             */
#include "mbed.h"
#include "SDFileSystem.h"
#define BUFFERSIZE 4096              // number of data in circular buffer
SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
Ticker SampleTicker;
int SampleRate;
float SamplePeriod;                       // sample period in microseconds
int CircularBuffer[BUFFERSIZE];           // circular buffer array
int ReadPointer=0;
int WritePointer=0;
bool EndOfFileFlag=0;

void DACFunction(void);                   // function prototype

int main() {
  FILE  *fp = fopen("/sd/testa.wav", "rb");     // open wave file
  fseek(fp, 24, SEEK_SET);                      // move to byte 24
  fread(&SampleRate, 4, 1, fp);                 // get sample frequency
  SamplePeriod=(float)1/SampleRate;   // calculate sample period as float
  SampleTicker.attach(&DACFunction,SamplePeriod);   // start output tick

  while (!feof(fp)) {          // loop until end of file is encountered 
    fread(&CircularBuffer[WritePointer], 2, 1, fp);
    WritePointer=WritePointer+1;        // increment Write Pointer
    if (WritePointer>=BUFFERSIZE) {     // if end of circular buffer
        WritePointer=0;                 // go back to start of buffer   
    }
  }
  EndOfFileFlag=1;
  fclose(fp);
}

// DAC function called at rate SamplePeriod
void DACFunction(void) {
  if ((EndOfFileFlag==0)|(ReadPointer>0)) { // output while data available
    DACout.write_u16(CircularBuffer[ReadPointer]);   // output to DAC
    ReadPointer=ReadPointer+1;                       // increment pointer
    if (ReadPointer>=BUFFERSIZE) {
      ReadPointer=0;                      // reset pointer if necessary
    }
  }
}

