/* Program Example 11.4 Wave file header reader
                                                               */
#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd");
Serial pc(USBTX,USBRX);                       // set up terminal link
char c1, c2, c3, c4;                          // chars for reading data in
int AudioFormat, NumChannels, SampleRate, BitsPerSample ; 

int main() {
    pc.printf("\n\rWave file header reader\n\r");
    FILE  *fp = fopen("/sd/sinewave.wav", "rb");    

    fseek(fp, 20, SEEK_SET);                    // set pointer to byte 20   

    fread(&AudioFormat, 2, 1, fp);              // check file is PCM
    if (AudioFormat==0x01) {
        pc.printf("Wav file is PCM data\n\r");
    } 
    else {
        pc.printf("Wav file is not PCM data\n\r");
    }

    fread(&NumChannels, 2, 1, fp);              // find number of channels
    pc.printf("Number of channels: %d\n\r",NumChannels);

    fread(&SampleRate, 4, 1, fp);               // find sample rate
    pc.printf("Sample rate: %d\n\r",SampleRate);

    fread(&BitsPerSample, 2, 1, fp);            // find resolution
    pc.printf("Bits per sample: %d\n\r",BitsPerSample);

    fclose(fp);
}

