/* Program Example 11.3 Delay / Echo Effect
                                                                */
#include "mbed.h"
AnalogIn Ain(p15);              //object definitions
AnalogOut Aout(p18);
AnalogIn delay_pot(p16);
AnalogIn feedback_pot(p17);
Ticker s20khz_tick; 
void s20khz_task(void);         // function prototypes
#define MAX_BUFFER 14000        // max data samples
signed short data_in;           // signed allows positive and negative
unsigned short data_out;        // unsigned just allows positive values
float delay=0;
float feedback=0;
signed short buffer[MAX_BUFFER]={0}; // define buffer and set values to 0 
int i=0;

//main program start here
int main() {
  s20khz_tick.attach_us(&s20khz_task,50);  
}
// function 20khz_task
void s20khz_task(void){
  data_in=Ain.read_u16()-0x7FFF;           // read data and normalise
  buffer[i]=data_in+(buffer[i]*feedback);  // add data to buffer data
  data_out=buffer[i]+0x7FFF;               // output buffer data value
  Aout.write_u16(data_out);                // write output
  if (i>(delay)){                          // if delay loop has completed
    i=0;                              // reset counter
    delay=delay_pot*MAX_BUFFER;       // calculate new delay buffer size
    feedback=(1-feedback_pot)*0.9;    // calculate feedback gain value
  }else{
    i=i+1;                            // otherwise increment delay counter
  }  
}

