/* Program Example 10.5: Pointers example for an array average function
                                                                     */
#include "mbed.h"
Serial pc(USBTX, USBRX);                               // setup serial comms
char data[]={5,7,5,8,9,1,7,8,2,5,1,4,6,2,1,4,3,8,7,9}; //define some input data
char *dataptr;                           // define a pointer for the input data
float average;                           // floating point average variable

float CalculateAverage(char *ptr, char size);     // function prototype

int main() {    
  dataptr=&data[0];       // point pointer to address of the first array element
  average = CalculateAverage(dataptr, sizeof(data));      // call function
  pc.printf("\n\rdata = ");
  for (char i=0; i<sizeof(data); i++) {           // loop for each data value
    pc.printf("%d ",data[i]);                     // display all the data values
  }
  pc.printf("\n\raverage = %.3f",average);        // display average value
}

     // CalculateAverage function definition and code 
float CalculateAverage(char *ptr, char size) {
  int sum=0;                // define variable for calculating the sum of the data
  float mean;               // define variable for floating point mean value
  for (char i=0; i<size; i++) {
    sum=sum + *(ptr+i);            // add all data elements together
  }
  mean=(float)sum/size;            // divide by size and cast to floating point
  return mean;             
}
